/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CachedInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.cachedinfo.CachedObject;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.CachedObjectParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class CachedInfoExtensionParser
extends ExtensionParser<CachedInfoExtensionMessage> {
    private List<CachedObject> cachedObjectList;

    public CachedInfoExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(CachedInfoExtensionMessage msg) {
        this.cachedObjectList = new LinkedList<CachedObject>();
        msg.setCachedInfoLength(this.parseIntField(2));
        byte[] cachedInfoBytes = this.parseByteArrayField((Integer)msg.getCachedInfoLength().getValue());
        msg.setCachedInfoBytes(cachedInfoBytes);
        ByteArrayInputStream innerStream = new ByteArrayInputStream(cachedInfoBytes);
        ConnectionEndType connectionEndType = this.getTlsContext().getTalkingConnectionEndType();
        while (innerStream.available() > 0) {
            CachedObjectParser parser = new CachedObjectParser(innerStream, connectionEndType);
            CachedObject object = new CachedObject();
            parser.parse(object);
            this.cachedObjectList.add(object);
        }
        msg.setCachedInfo(this.cachedObjectList);
    }
}

