/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.RSAServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ServerKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RSAServerKeyExchangeParser<T extends RSAServerKeyExchangeMessage>
extends ServerKeyExchangeParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public RSAServerKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(RSAServerKeyExchangeMessage msg) {
        LOGGER.debug("Parsing RSAServerKeyExchangeMessage");
        this.parseModulusLength(msg);
        this.parseModulus(msg);
        this.parsePublicExponentLength(msg);
        this.parsePublicExponent(msg);
        if (this.isTLS12() || this.isDTLS12()) {
            this.parseSignatureAndHashAlgorithm(msg);
        }
        this.parseSignatureLength(msg);
        this.parseSignature(msg);
    }

    private void parseModulusLength(RSAServerKeyExchangeMessage msg) {
        msg.setModulusLength(this.parseIntField(2));
        LOGGER.debug("Modulus Length: {}", msg.getModulusLength().getValue());
    }

    private void parseModulus(RSAServerKeyExchangeMessage msg) {
        msg.setModulus(this.parseByteArrayField((Integer)msg.getModulusLength().getValue()));
        LOGGER.debug("Modulus: {}", msg.getModulus().getValue());
    }

    private void parsePublicExponentLength(RSAServerKeyExchangeMessage msg) {
        msg.setPublicKeyLength(this.parseIntField(2));
        LOGGER.debug("Public Exponent Length: {}", msg.getPublicKeyLength().getValue());
    }

    private void parsePublicExponent(RSAServerKeyExchangeMessage msg) {
        msg.setPublicKey(this.parseByteArrayField((Integer)msg.getPublicKeyLength().getValue()));
        LOGGER.debug("Public Exponent: {}", msg.getPublicKey().getValue());
    }

    private void parseSignatureAndHashAlgorithm(RSAServerKeyExchangeMessage msg) {
        msg.setSignatureAndHashAlgorithm(this.parseByteArrayField(2));
        LOGGER.debug("SignatureAndHashAlgorithm: {}", msg.getSignatureAndHashAlgorithm().getValue());
    }

    private void parseSignatureLength(RSAServerKeyExchangeMessage msg) {
        msg.setSignatureLength(this.parseIntField(2));
        LOGGER.debug("SignatureLength: {}", msg.getSignatureLength().getValue());
    }

    private void parseSignature(RSAServerKeyExchangeMessage msg) {
        msg.setSignature(this.parseByteArrayField((Integer)msg.getSignatureLength().getValue()));
        LOGGER.debug("Signature: {}", msg.getSignature().getValue());
    }
}

