/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.PskDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.DHEServerKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskDheServerKeyExchangeParser
extends DHEServerKeyExchangeParser<PskDheServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PskDheServerKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
        this.setKeyExchangeAlgorithm(KeyExchangeAlgorithm.DHE_PSK);
    }

    @Override
    public void parse(PskDheServerKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PSKDHEServerKeyExchangeMessage");
        this.parsePskIdentityHintLength(msg);
        this.parsePskIdentityHint(msg);
        super.parseDheParams(msg);
    }

    private void parsePskIdentityHintLength(PskDheServerKeyExchangeMessage msg) {
        msg.setIdentityHintLength(this.parseIntField(2));
        LOGGER.debug("SerializedPSK-IdentityLength: {}", msg.getIdentityHintLength().getValue());
    }

    private void parsePskIdentityHint(PskDheServerKeyExchangeMessage msg) {
        msg.setIdentityHint(this.parseByteArrayField((Integer)msg.getIdentityHintLength().getValue()));
        LOGGER.debug("SerializedPSK-Identity: {}", msg.getIdentityHint().getValue());
    }
}

