/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.DHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ServerKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DHEServerKeyExchangeParser<T extends DHEServerKeyExchangeMessage>
extends ServerKeyExchangeParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public DHEServerKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(DHEServerKeyExchangeMessage msg) {
        LOGGER.debug("Parsing DHEServerKeyExchangeMessage");
        this.parsePLength(msg);
        this.parseP(msg);
        this.parseGLength(msg);
        this.parseG(msg);
        this.parseSerializedPublicKeyLength(msg);
        this.parseSerializedPublicKey(msg);
        if (this.shouldParseSignature()) {
            if (this.isTLS12() || this.isDTLS12()) {
                this.parseSignatureAndHashAlgorithm(msg);
            }
            this.parseSignatureLength(msg);
            this.parseSignature(msg);
        }
    }

    protected void parseDheParams(T msg) {
        this.parsePLength((DHEServerKeyExchangeMessage)msg);
        this.parseP((DHEServerKeyExchangeMessage)msg);
        this.parseGLength((DHEServerKeyExchangeMessage)msg);
        this.parseG((DHEServerKeyExchangeMessage)msg);
        this.parseSerializedPublicKeyLength((DHEServerKeyExchangeMessage)msg);
        this.parseSerializedPublicKey((DHEServerKeyExchangeMessage)msg);
    }

    private void parsePLength(DHEServerKeyExchangeMessage msg) {
        msg.setModulusLength(this.parseIntField(2));
        LOGGER.debug("pLength: {}", msg.getModulusLength().getValue());
    }

    private void parseP(DHEServerKeyExchangeMessage msg) {
        msg.setModulus(this.parseByteArrayField((Integer)msg.getModulusLength().getValue()));
        LOGGER.debug("P: {}", msg.getModulus().getValue());
    }

    private void parseGLength(DHEServerKeyExchangeMessage msg) {
        msg.setGeneratorLength(this.parseIntField(2));
        LOGGER.debug("gLength: {}", msg.getGeneratorLength().getValue());
    }

    private void parseG(DHEServerKeyExchangeMessage msg) {
        msg.setGenerator(this.parseByteArrayField((Integer)msg.getGeneratorLength().getValue()));
        LOGGER.debug("G: {}", msg.getGenerator().getValue());
    }

    private void parseSerializedPublicKeyLength(DHEServerKeyExchangeMessage msg) {
        msg.setPublicKeyLength(this.parseIntField(2));
        LOGGER.debug("SerializedPublicKeyLength: {}", msg.getPublicKeyLength().getValue());
    }

    private void parseSerializedPublicKey(DHEServerKeyExchangeMessage msg) {
        msg.setPublicKey(this.parseByteArrayField((Integer)msg.getPublicKeyLength().getValue()));
        LOGGER.debug("SerializedPublicKey: {}", msg.getPublicKey().getValue());
    }

    private void parseSignatureAndHashAlgorithm(DHEServerKeyExchangeMessage msg) {
        msg.setSignatureAndHashAlgorithm(this.parseByteArrayField(2));
        LOGGER.debug("SignatureAndHashAlgorithm: {}", msg.getSignatureAndHashAlgorithm().getValue());
    }

    private void parseSignatureLength(DHEServerKeyExchangeMessage msg) {
        msg.setSignatureLength(this.parseIntField(2));
        LOGGER.debug("SignatureLength: {}", msg.getSignatureLength().getValue());
    }

    private void parseSignature(DHEServerKeyExchangeMessage msg) {
        msg.setSignature(this.parseByteArrayField((Integer)msg.getSignatureLength().getValue()));
        LOGGER.debug("Signature: {}", msg.getSignature().getValue());
    }
}

