/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.CoreClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HelloMessageParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CoreClientHelloParser<T extends CoreClientHelloMessage>
extends HelloMessageParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CoreClientHelloParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(T msg) {
        LOGGER.debug("Parsing ClientHelloMessage");
        this.parseProtocolVersion((HelloMessage)msg);
        this.parseRandom((HelloMessage)msg);
        this.parseSessionIDLength((HelloMessage)msg);
        this.parseSessionID((HelloMessage)msg);
        if (this.getVersion().isDTLS()) {
            ((CoreClientHelloMessage)msg).setCookieLength(this.parseByteField(1));
            ((CoreClientHelloMessage)msg).setCookie(this.parseByteArrayField((Integer)((CoreClientHelloMessage)msg).getCookieLength().getValue()));
        }
        this.parseCipherSuiteLength(msg);
        this.parseCipherSuites(msg);
        this.parseCompressionLength(msg);
        this.parseCompressions(msg);
        if (this.hasExtensionLengthField()) {
            this.parseExtensionLength(msg);
            if (this.hasExtensions(msg)) {
                this.parseExtensionBytes(msg, false);
            }
        }
    }

    private void parseCipherSuiteLength(T msg) {
        ((CoreClientHelloMessage)msg).setCipherSuiteLength(this.parseIntField(2));
        LOGGER.debug("CipherSuiteLength: {}", ((CoreClientHelloMessage)msg).getCipherSuiteLength().getValue());
    }

    private void parseCipherSuites(T msg) {
        ((CoreClientHelloMessage)msg).setCipherSuites(this.parseByteArrayField((Integer)((CoreClientHelloMessage)msg).getCipherSuiteLength().getValue()));
        LOGGER.debug("CipherSuites: {}", ((CoreClientHelloMessage)msg).getCipherSuites().getValue());
    }

    private void parseCompressionLength(T msg) {
        ((CoreClientHelloMessage)msg).setCompressionLength(this.parseIntField(1));
        LOGGER.debug("CompressionLength: {}", ((CoreClientHelloMessage)msg).getCompressionLength().getValue());
    }

    private void parseCompressions(T msg) {
        ((CoreClientHelloMessage)msg).setCompressions(this.parseByteArrayField((Integer)((CoreClientHelloMessage)msg).getCompressionLength().getValue()));
        LOGGER.debug("Compressions: {}", ((CoreClientHelloMessage)msg).getCompressions().getValue());
    }
}

