/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension.quic.constants;

import java.util.HashMap;
import java.util.Map;

public enum QuicTransportParameterEntryTypes {
    ORIGINAL_DESTINATION_CONNECTION_ID(0),
    MAX_IDLE_TIMEOUT(1),
    STATELESS_RESET_TOKEN(2),
    MAX_UDP_PAYLOAD_SIZE(3),
    INITIAL_MAX_DATA(4),
    INITIAL_MAX_STREAM_DATA_BIDI_LOCAL(5),
    INITIAL_MAX_STREAM_DATA_BIDI_REMOTE(6),
    INITIAL_MAX_STREAM_DATA_UNI(7),
    INITIAL_MAX_STREAMS_BIDI(8),
    INITIAL_MAX_STREAMS_UNI(9),
    ACK_DELAY_EXPONENT(10),
    MAX_ACK_DELAY(11),
    DISABLE_ACTIVE_MIGRATION(12),
    PREFERRED_ADDRESS(13),
    ACTIVE_CONNECTION_ID_LIMIT(14),
    INITIAL_SOURCE_CONNECTION_ID(15),
    RETRY_SOURCE_CONNECTION_ID(16),
    MAX_DATAGRAM_FRAME_SIZE(32),
    GOOGLE(71),
    PROVISIONAL_PARAMETERS(49),
    UNKNOWN(-1);

    private byte value;
    private static final Map<Byte, QuicTransportParameterEntryTypes> MAP;

    private QuicTransportParameterEntryTypes(byte value) {
        this.value = value;
    }

    public static QuicTransportParameterEntryTypes getParameterEntryType(byte value) {
        QuicTransportParameterEntryTypes type = MAP.get(value);
        if (type == null) {
            return UNKNOWN;
        }
        return type;
    }

    public byte getValue() {
        return this.value;
    }

    static {
        MAP = new HashMap<Byte, QuicTransportParameterEntryTypes>();
        for (QuicTransportParameterEntryTypes c : QuicTransportParameterEntryTypes.values()) {
            MAP.put(c.value, c);
        }
    }
}

