/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension.quic;

import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParameterEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParametersExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.constants.QuicTransportParameterEntryTypes;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class QuicTransportParameters {
    private byte[] originalDestinationConnectionId;
    private byte[] initialSourceConnectionId;
    private byte[] retrySourceConnectionId;
    private Long maxIdleTimeout;
    private Long maxUdpPayloadSize;
    private Long initialMaxData;
    private Long initialMaxStreamDataBidiLocal;
    private Long initialMaxStreamDataBidiRemote;
    private Long initialMaxStreamDataUni;
    private Long initialMaxStreamsBidi;
    private Long initialMaxStreamsUni;
    private Long ackDelayExponent;
    private Long maxAckDelay;
    private Long activeConnectionIdLimit;
    private boolean disableActiveMigration;
    private List<QuicTransportParameterEntry> extraEntries;
    private QuicTransportParametersExtensionMessage.PreferredAddress preferredAddress;

    public QuicTransportParameters() {
    }

    public QuicTransportParameters(List<QuicTransportParameterEntry> quicTransportParameterEntryList) {
        this.extraEntries = new ArrayList<QuicTransportParameterEntry>();
        block18: for (QuicTransportParameterEntry parameterEntry : quicTransportParameterEntryList) {
            switch (parameterEntry.getEntryType()) {
                case ORIGINAL_DESTINATION_CONNECTION_ID: {
                    this.originalDestinationConnectionId = (byte[])parameterEntry.getEntryValue().getValue();
                    continue block18;
                }
                case INITIAL_SOURCE_CONNECTION_ID: {
                    this.initialSourceConnectionId = (byte[])parameterEntry.getEntryValue().getValue();
                    continue block18;
                }
                case RETRY_SOURCE_CONNECTION_ID: {
                    this.retrySourceConnectionId = (byte[])parameterEntry.getEntryValue().getValue();
                    continue block18;
                }
                case MAX_IDLE_TIMEOUT: {
                    this.maxIdleTimeout = VariableLengthIntegerEncoding.decodeVariableLengthInteger((byte[])parameterEntry.getEntryValue().getValue());
                    continue block18;
                }
                case MAX_UDP_PAYLOAD_SIZE: {
                    this.maxUdpPayloadSize = VariableLengthIntegerEncoding.decodeVariableLengthInteger((byte[])parameterEntry.getEntryValue().getValue());
                    continue block18;
                }
                case INITIAL_MAX_DATA: {
                    this.initialMaxData = VariableLengthIntegerEncoding.decodeVariableLengthInteger((byte[])parameterEntry.getEntryValue().getValue());
                    continue block18;
                }
                case INITIAL_MAX_STREAM_DATA_BIDI_LOCAL: {
                    this.initialMaxStreamDataBidiLocal = VariableLengthIntegerEncoding.decodeVariableLengthInteger((byte[])parameterEntry.getEntryValue().getValue());
                    continue block18;
                }
                case INITIAL_MAX_STREAM_DATA_BIDI_REMOTE: {
                    this.initialMaxStreamDataBidiRemote = VariableLengthIntegerEncoding.decodeVariableLengthInteger((byte[])parameterEntry.getEntryValue().getValue());
                    continue block18;
                }
                case INITIAL_MAX_STREAM_DATA_UNI: {
                    this.initialMaxStreamDataUni = VariableLengthIntegerEncoding.decodeVariableLengthInteger((byte[])parameterEntry.getEntryValue().getValue());
                    continue block18;
                }
                case INITIAL_MAX_STREAMS_BIDI: {
                    this.initialMaxStreamsBidi = VariableLengthIntegerEncoding.decodeVariableLengthInteger((byte[])parameterEntry.getEntryValue().getValue());
                    continue block18;
                }
                case INITIAL_MAX_STREAMS_UNI: {
                    this.initialMaxStreamsUni = VariableLengthIntegerEncoding.decodeVariableLengthInteger((byte[])parameterEntry.getEntryValue().getValue());
                    continue block18;
                }
                case ACK_DELAY_EXPONENT: {
                    this.ackDelayExponent = VariableLengthIntegerEncoding.decodeVariableLengthInteger((byte[])parameterEntry.getEntryValue().getValue());
                    continue block18;
                }
                case MAX_ACK_DELAY: {
                    this.maxAckDelay = VariableLengthIntegerEncoding.decodeVariableLengthInteger((byte[])parameterEntry.getEntryValue().getValue());
                    continue block18;
                }
                case ACTIVE_CONNECTION_ID_LIMIT: {
                    this.activeConnectionIdLimit = VariableLengthIntegerEncoding.decodeVariableLengthInteger((byte[])parameterEntry.getEntryValue().getValue());
                    continue block18;
                }
                case DISABLE_ACTIVE_MIGRATION: {
                    this.disableActiveMigration = true;
                    continue block18;
                }
                case PREFERRED_ADDRESS: {
                    this.preferredAddress = new QuicTransportParametersExtensionMessage.PreferredAddress((byte[])parameterEntry.getEntryValue().getValue());
                    continue block18;
                }
            }
            this.extraEntries.add(parameterEntry);
        }
    }

    public static QuicTransportParameters getDefaultParameters() {
        QuicTransportParameters quicTransportParameters = new QuicTransportParameters();
        quicTransportParameters.setMaxIdleTimeout(60000L);
        quicTransportParameters.setMaxUdpPayloadSize(65527L);
        quicTransportParameters.setInitialMaxData(2149983648L);
        quicTransportParameters.setInitialMaxStreamDataBidiLocal(2149983648L);
        quicTransportParameters.setInitialMaxStreamDataBidiRemote(2149983648L);
        quicTransportParameters.setInitialMaxStreamDataUni(2149983648L);
        quicTransportParameters.setInitialMaxStreamsBidi(0x80040000L);
        quicTransportParameters.setInitialMaxStreamsUni(0x80040000L);
        quicTransportParameters.setAckDelayExponent(0L);
        quicTransportParameters.setMaxAckDelay(2000L);
        return quicTransportParameters;
    }

    public List<QuicTransportParameterEntry> toListOfEntries() {
        ArrayList<QuicTransportParameterEntry> entryList = new ArrayList<QuicTransportParameterEntry>();
        if (this.originalDestinationConnectionId != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.ORIGINAL_DESTINATION_CONNECTION_ID, this.originalDestinationConnectionId));
        }
        if (this.initialSourceConnectionId != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.INITIAL_SOURCE_CONNECTION_ID, this.initialSourceConnectionId));
        }
        if (this.retrySourceConnectionId != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.RETRY_SOURCE_CONNECTION_ID, this.retrySourceConnectionId));
        }
        if (this.maxIdleTimeout != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.MAX_IDLE_TIMEOUT, this.maxIdleTimeout));
        }
        if (this.maxUdpPayloadSize != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.MAX_UDP_PAYLOAD_SIZE, this.maxUdpPayloadSize));
        }
        if (this.initialMaxData != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.INITIAL_MAX_DATA, this.initialMaxData));
        }
        if (this.initialMaxStreamDataBidiLocal != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.INITIAL_MAX_STREAM_DATA_BIDI_LOCAL, this.initialMaxStreamDataBidiLocal));
        }
        if (this.initialMaxStreamDataBidiRemote != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.INITIAL_MAX_STREAM_DATA_BIDI_REMOTE, this.initialMaxStreamDataBidiRemote));
        }
        if (this.initialMaxStreamDataUni != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.INITIAL_MAX_STREAM_DATA_UNI, this.initialMaxStreamDataUni));
        }
        if (this.initialMaxStreamsBidi != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.INITIAL_MAX_STREAMS_BIDI, this.initialMaxStreamsBidi));
        }
        if (this.initialMaxStreamsUni != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.INITIAL_MAX_STREAMS_UNI, this.initialMaxStreamsUni));
        }
        if (this.ackDelayExponent != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.ACK_DELAY_EXPONENT, this.ackDelayExponent));
        }
        if (this.maxAckDelay != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.MAX_ACK_DELAY, this.maxAckDelay));
        }
        if (this.disableActiveMigration) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.DISABLE_ACTIVE_MIGRATION, new byte[0]));
        }
        if (this.preferredAddress != null) {
            try {
                entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.PREFERRED_ADDRESS, this.preferredAddress.serialize()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.activeConnectionIdLimit != null) {
            entryList.add(new QuicTransportParameterEntry(QuicTransportParameterEntryTypes.ACTIVE_CONNECTION_ID_LIMIT, this.activeConnectionIdLimit));
        }
        if (this.extraEntries != null) {
            entryList.addAll(this.extraEntries);
        }
        return entryList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuicTransportParameters that = (QuicTransportParameters)o;
        if (!Objects.equals(this.maxIdleTimeout, that.maxIdleTimeout)) {
            return false;
        }
        if (!Objects.equals(this.maxUdpPayloadSize, that.maxUdpPayloadSize)) {
            return false;
        }
        if (!Objects.equals(this.initialMaxData, that.initialMaxData)) {
            return false;
        }
        if (!Objects.equals(this.initialMaxStreamDataBidiLocal, that.initialMaxStreamDataBidiLocal)) {
            return false;
        }
        if (!Objects.equals(this.initialMaxStreamDataBidiRemote, that.initialMaxStreamDataBidiRemote)) {
            return false;
        }
        if (!Objects.equals(this.initialMaxStreamDataUni, that.initialMaxStreamDataUni)) {
            return false;
        }
        if (!Objects.equals(this.initialMaxStreamsBidi, that.initialMaxStreamsBidi)) {
            return false;
        }
        if (!Objects.equals(this.initialMaxStreamsUni, that.initialMaxStreamsUni)) {
            return false;
        }
        if (!Objects.equals(this.ackDelayExponent, that.ackDelayExponent)) {
            return false;
        }
        if (!Objects.equals(this.maxAckDelay, that.maxAckDelay)) {
            return false;
        }
        if (!Objects.equals(this.activeConnectionIdLimit, that.activeConnectionIdLimit)) {
            return false;
        }
        if (this.disableActiveMigration != that.disableActiveMigration) {
            return false;
        }
        if (!Arrays.equals(this.originalDestinationConnectionId, that.originalDestinationConnectionId)) {
            return false;
        }
        if (!Arrays.equals(this.initialSourceConnectionId, that.initialSourceConnectionId)) {
            return false;
        }
        if (!Arrays.equals(this.retrySourceConnectionId, that.retrySourceConnectionId)) {
            return false;
        }
        if (this.extraEntries != null && !this.extraEntries.containsAll(that.extraEntries)) {
            return false;
        }
        return Objects.equals(this.preferredAddress, that.preferredAddress);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.originalDestinationConnectionId);
        result = 31 * result + Arrays.hashCode(this.initialSourceConnectionId);
        result = 31 * result + Arrays.hashCode(this.retrySourceConnectionId);
        result = 31 * result + (int)(this.maxIdleTimeout ^ this.maxIdleTimeout >>> 32);
        result = 31 * result + (int)(this.maxUdpPayloadSize ^ this.maxUdpPayloadSize >>> 32);
        result = 31 * result + (int)(this.initialMaxData ^ this.initialMaxData >>> 32);
        result = 31 * result + (int)(this.initialMaxStreamDataBidiLocal ^ this.initialMaxStreamDataBidiLocal >>> 32);
        result = 31 * result + (int)(this.initialMaxStreamDataBidiRemote ^ this.initialMaxStreamDataBidiRemote >>> 32);
        result = 31 * result + (int)(this.initialMaxStreamDataUni ^ this.initialMaxStreamDataUni >>> 32);
        result = 31 * result + (int)(this.initialMaxStreamsBidi ^ this.initialMaxStreamsBidi >>> 32);
        result = 31 * result + (int)(this.initialMaxStreamsUni ^ this.initialMaxStreamsUni >>> 32);
        result = 31 * result + (int)(this.ackDelayExponent ^ this.ackDelayExponent >>> 32);
        result = 31 * result + (int)(this.maxAckDelay ^ this.maxAckDelay >>> 32);
        result = 31 * result + (int)(this.activeConnectionIdLimit ^ this.activeConnectionIdLimit >>> 32);
        result = 31 * result + (this.disableActiveMigration ? 1 : 0);
        result = 31 * result + (this.extraEntries != null ? this.extraEntries.hashCode() : 0);
        result = 31 * result + (this.preferredAddress != null ? this.preferredAddress.hashCode() : 0);
        return result;
    }

    public byte[] getOriginalDestinationConnectionId() {
        return this.originalDestinationConnectionId;
    }

    public void setOriginalDestinationConnectionId(byte[] originalDestinationConnectionId) {
        this.originalDestinationConnectionId = originalDestinationConnectionId;
    }

    public byte[] getInitialSourceConnectionId() {
        return this.initialSourceConnectionId;
    }

    public void setInitialSourceConnectionId(byte[] initialSourceConnectionId) {
        this.initialSourceConnectionId = initialSourceConnectionId;
    }

    public byte[] getRetrySourceConnectionId() {
        return this.retrySourceConnectionId;
    }

    public void setRetrySourceConnectionId(byte[] retrySourceConnectionId) {
        this.retrySourceConnectionId = retrySourceConnectionId;
    }

    public Long getMaxIdleTimeout() {
        return this.maxIdleTimeout;
    }

    public void setMaxIdleTimeout(Long maxIdleTimeout) {
        this.maxIdleTimeout = maxIdleTimeout;
    }

    public Long getMaxUdpPayloadSize() {
        return this.maxUdpPayloadSize;
    }

    public void setMaxUdpPayloadSize(Long maxUdpPayloadSize) {
        this.maxUdpPayloadSize = maxUdpPayloadSize;
    }

    public Long getInitialMaxData() {
        return this.initialMaxData;
    }

    public void setInitialMaxData(Long initialMaxData) {
        this.initialMaxData = initialMaxData;
    }

    public Long getInitialMaxStreamDataBidiLocal() {
        return this.initialMaxStreamDataBidiLocal;
    }

    public void setInitialMaxStreamDataBidiLocal(Long initialMaxStreamDataBidiLocal) {
        this.initialMaxStreamDataBidiLocal = initialMaxStreamDataBidiLocal;
    }

    public Long getInitialMaxStreamDataBidiRemote() {
        return this.initialMaxStreamDataBidiRemote;
    }

    public void setInitialMaxStreamDataBidiRemote(Long initialMaxStreamDataBidiRemote) {
        this.initialMaxStreamDataBidiRemote = initialMaxStreamDataBidiRemote;
    }

    public Long getInitialMaxStreamDataUni() {
        return this.initialMaxStreamDataUni;
    }

    public void setInitialMaxStreamDataUni(Long initialMaxStreamDataUni) {
        this.initialMaxStreamDataUni = initialMaxStreamDataUni;
    }

    public Long getInitialMaxStreamsBidi() {
        return this.initialMaxStreamsBidi;
    }

    public void setInitialMaxStreamsBidi(Long initialMaxStreamsBidi) {
        this.initialMaxStreamsBidi = initialMaxStreamsBidi;
    }

    public Long getInitialMaxStreamsUni() {
        return this.initialMaxStreamsUni;
    }

    public void setInitialMaxStreamsUni(Long initialMaxStreamsUni) {
        this.initialMaxStreamsUni = initialMaxStreamsUni;
    }

    public Long getAckDelayExponent() {
        return this.ackDelayExponent;
    }

    public void setAckDelayExponent(Long ackDelayExponent) {
        this.ackDelayExponent = ackDelayExponent;
    }

    public Long getMaxAckDelay() {
        return this.maxAckDelay;
    }

    public void setMaxAckDelay(Long maxAckDelay) {
        this.maxAckDelay = maxAckDelay;
    }

    public Long getActiveConnectionIdLimit() {
        return this.activeConnectionIdLimit;
    }

    public void setActiveConnectionIdLimit(Long activeConnectionIdLimit) {
        this.activeConnectionIdLimit = activeConnectionIdLimit;
    }

    public boolean isDisableActiveMigration() {
        return this.disableActiveMigration;
    }

    public void setDisableActiveMigration(boolean disableActiveMigration) {
        this.disableActiveMigration = disableActiveMigration;
    }

    public List<QuicTransportParameterEntry> getExtraEntries() {
        return this.extraEntries;
    }

    public void setExtraEntries(List<QuicTransportParameterEntry> extraEntries) {
        this.extraEntries = new ArrayList<QuicTransportParameterEntry>(extraEntries);
    }

    public QuicTransportParametersExtensionMessage.PreferredAddress getPreferredAddress() {
        return this.preferredAddress;
    }

    public void setPreferredAddress(QuicTransportParametersExtensionMessage.PreferredAddress preferredAddress) {
        this.preferredAddress = preferredAddress;
    }
}

