/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.protocol.handler.SrpClientKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.SRPClientComputations;
import de.rub.nds.tlsattacker.core.protocol.parser.SrpClientKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.SrpClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.SrpClientKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.List;

@XmlRootElement(name="SrpClientKeyExchange")
public class SrpClientKeyExchangeMessage
extends ClientKeyExchangeMessage {
    @ModifiableVariableProperty
    private ModifiableByteArray modulus;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger modulusLength;
    @ModifiableVariableProperty
    private ModifiableByteArray generator;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger generatorLength;
    @HoldsModifiableVariable
    protected SRPClientComputations computations;
    @ModifiableVariableProperty
    private ModifiableByteArray salt;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger saltLength;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SrpClientKeyExchangeMessage:\n");
        return sb.toString();
    }

    public ModifiableByteArray getModulus() {
        return this.modulus;
    }

    public void setModulus(ModifiableByteArray modulus) {
        this.modulus = modulus;
    }

    public void setModulus(byte[] modulus) {
        this.modulus = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.modulus, (byte[])modulus);
    }

    public ModifiableByteArray getGenerator() {
        return this.generator;
    }

    public void setGenerator(ModifiableByteArray generator) {
        this.generator = generator;
    }

    public void setGenerator(byte[] generator) {
        this.generator = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.generator, (byte[])generator);
    }

    public ModifiableInteger getModulusLength() {
        return this.modulusLength;
    }

    public void setModulusLength(ModifiableInteger modulusLength) {
        this.modulusLength = modulusLength;
    }

    public void setModulusLength(int modulusLength) {
        this.modulusLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.modulusLength, (Integer)modulusLength);
    }

    public ModifiableInteger getGeneratorLength() {
        return this.generatorLength;
    }

    public void setGeneratorLength(ModifiableInteger generatorLength) {
        this.generatorLength = generatorLength;
    }

    public void setGeneratorLength(int generatorLength) {
        this.generatorLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.generatorLength, (Integer)generatorLength);
    }

    @Override
    public SRPClientComputations getComputations() {
        return this.computations;
    }

    @Override
    public SrpClientKeyExchangeHandler getHandler(Context context) {
        return new SrpClientKeyExchangeHandler(context.getTlsContext());
    }

    @Override
    public SrpClientKeyExchangeParser getParser(Context context, InputStream stream) {
        return new SrpClientKeyExchangeParser(stream, context.getTlsContext());
    }

    @Override
    public SrpClientKeyExchangePreparator getPreparator(Context context) {
        return new SrpClientKeyExchangePreparator(context.getChooser(), this);
    }

    @Override
    public SrpClientKeyExchangeSerializer getSerializer(Context context) {
        return new SrpClientKeyExchangeSerializer(this);
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SRP_CLIENT_KEY_EXCHANGE");
        if (this.isRetransmission()) {
            sb.append(" (ret.)");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "SRP_CKE";
    }

    @Override
    public void prepareComputations() {
        if (this.getComputations() == null) {
            this.computations = new SRPClientComputations();
        }
    }

    @Override
    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List<ModifiableVariableHolder> holders = super.getAllModifiableVariableHolders();
        if (this.computations != null) {
            holders.add(this.computations);
        }
        return holders;
    }

    public ModifiableByteArray getSalt() {
        return this.salt;
    }

    public void setSalt(ModifiableByteArray salt) {
        this.salt = salt;
    }

    public void setSalt(byte[] salt) {
        this.salt = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.salt, (byte[])salt);
    }

    public ModifiableInteger getSaltLength() {
        return this.saltLength;
    }

    public void setSaltLength(ModifiableInteger saltLength) {
        this.saltLength = saltLength;
    }

    public void setSaltLength(int saltLength) {
        this.saltLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.saltLength, (Integer)saltLength);
    }
}

