/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.SSL2MessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.SSL2ServerHelloHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import de.rub.nds.tlsattacker.core.protocol.parser.SSL2ServerHelloParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.SSL2ServerHelloPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.SSL2ServerHelloSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.Objects;

@XmlRootElement(name="SSL2ServerHello")
public class SSL2ServerHelloMessage
extends SSL2Message {
    @ModifiableVariableProperty
    private ModifiableByte sessionIdHit;
    @ModifiableVariableProperty
    private ModifiableByte certificateType;
    @ModifiableVariableProperty
    private ModifiableByteArray protocolVersion;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger certificateLength;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger cipherSuitesLength;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger sessionIdLength;
    @ModifiableVariableProperty
    private ModifiableByteArray certificate;
    @ModifiableVariableProperty
    private ModifiableByteArray cipherSuites;
    @ModifiableVariableProperty
    private ModifiableByteArray sessionId;

    public SSL2ServerHelloMessage() {
        super(SSL2MessageType.SSL_SERVER_HELLO);
        this.protocolMessageType = ProtocolMessageType.HANDSHAKE;
    }

    @Override
    public String toCompactString() {
        return "SSL2 ServerHello Message";
    }

    @Override
    public SSL2ServerHelloHandler getHandler(Context context) {
        return new SSL2ServerHelloHandler(context.getTlsContext());
    }

    @Override
    public SSL2ServerHelloParser getParser(Context context, InputStream stream) {
        return new SSL2ServerHelloParser(stream, context.getTlsContext());
    }

    @Override
    public SSL2ServerHelloPreparator getPreparator(Context context) {
        return new SSL2ServerHelloPreparator(context.getChooser(), this);
    }

    @Override
    public SSL2ServerHelloSerializer getSerializer(Context context) {
        return new SSL2ServerHelloSerializer(this);
    }

    public ModifiableByte getSessionIdHit() {
        return this.sessionIdHit;
    }

    public void setSessionIdHit(ModifiableByte sessionIdHit) {
        this.sessionIdHit = sessionIdHit;
    }

    public void setSessionIdHit(byte sessionIdHit) {
        this.sessionIdHit = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.sessionIdHit, (Byte)sessionIdHit);
    }

    public ModifiableByte getCertificateType() {
        return this.certificateType;
    }

    public void setCertificateType(ModifiableByte certificateType) {
        this.certificateType = certificateType;
    }

    public void setCertificateType(byte certificateType) {
        this.certificateType = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.certificateType, (Byte)certificateType);
    }

    public ModifiableByteArray getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ModifiableByteArray protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setProtocolVersion(byte[] protocolVersion) {
        this.protocolVersion = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protocolVersion, (byte[])protocolVersion);
    }

    public ModifiableInteger getCertificateLength() {
        return this.certificateLength;
    }

    public void setCertificateLength(int certificateLength) {
        this.certificateLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.certificateLength, (Integer)certificateLength);
    }

    public void setCertificateLength(ModifiableInteger certificateLength) {
        this.certificateLength = certificateLength;
    }

    public ModifiableInteger getCipherSuitesLength() {
        return this.cipherSuitesLength;
    }

    public void setCipherSuitesLength(ModifiableInteger cipherSuitesLength) {
        this.cipherSuitesLength = cipherSuitesLength;
    }

    public void setCipherSuitesLength(int cipherSuitesLength) {
        this.cipherSuitesLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.cipherSuitesLength, (Integer)cipherSuitesLength);
    }

    public ModifiableInteger getSessionIdLength() {
        return this.sessionIdLength;
    }

    public void setSessionIdLength(ModifiableInteger sessionIdLength) {
        this.sessionIdLength = sessionIdLength;
    }

    public void setSessionIDLength(int connectionIDLength) {
        this.sessionIdLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.sessionIdLength, (Integer)connectionIDLength);
    }

    public ModifiableByteArray getCertificate() {
        return this.certificate;
    }

    public void setCertificate(ModifiableByteArray certificate) {
        this.certificate = certificate;
    }

    public void setCertificate(byte[] certificate) {
        this.certificate = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.certificate, (byte[])certificate);
    }

    public ModifiableByteArray getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(ModifiableByteArray cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setCipherSuites(byte[] cipherSuites) {
        this.cipherSuites = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cipherSuites, (byte[])cipherSuites);
    }

    public ModifiableByteArray getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(ModifiableByteArray sessionId) {
        this.sessionId = sessionId;
    }

    public void setSessionID(byte[] sessionID) {
        this.sessionId = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.sessionId, (byte[])sessionID);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSL2ServerHelloMessage:");
        sb.append("\n  Protocol Version: ");
        if (this.getProtocolVersion() != null && this.getProtocolVersion().getValue() != null) {
            sb.append((Object)ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Type: ");
        if (this.getType() != null && this.getType().getValue() != null) {
            sb.append(this.getType().getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Supported CipherSuites: ");
        if (this.getCipherSuites() != null && this.getCipherSuites().getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getCipherSuites().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  SessionIdHit: ");
        if (this.getSessionIdHit() != null && this.getSessionIdHit().getValue() != null) {
            sb.append(this.getSessionIdHit().getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Certificate: ");
        if (this.getCertificate() != null && this.getCertificate().getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getCertificate().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  SessionID: ");
        if (this.getSessionId() != null && this.getSessionId().getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getSessionId().getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "SSL2_SH";
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.sessionIdHit);
        hash = 89 * hash + Objects.hashCode(this.certificateType);
        hash = 89 * hash + Objects.hashCode(this.protocolVersion);
        hash = 89 * hash + Objects.hashCode(this.certificateLength);
        hash = 89 * hash + Objects.hashCode(this.cipherSuitesLength);
        hash = 89 * hash + Objects.hashCode(this.sessionIdLength);
        hash = 89 * hash + Objects.hashCode(this.certificate);
        hash = 89 * hash + Objects.hashCode(this.cipherSuites);
        hash = 89 * hash + Objects.hashCode(this.sessionId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SSL2ServerHelloMessage other = (SSL2ServerHelloMessage)obj;
        if (!Objects.equals(this.sessionIdHit, other.sessionIdHit)) {
            return false;
        }
        if (!Objects.equals(this.certificateType, other.certificateType)) {
            return false;
        }
        if (!Objects.equals(this.protocolVersion, other.protocolVersion)) {
            return false;
        }
        if (!Objects.equals(this.certificateLength, other.certificateLength)) {
            return false;
        }
        if (!Objects.equals(this.cipherSuitesLength, other.cipherSuitesLength)) {
            return false;
        }
        if (!Objects.equals(this.sessionIdLength, other.sessionIdLength)) {
            return false;
        }
        if (!Objects.equals(this.certificate, other.certificate)) {
            return false;
        }
        if (!Objects.equals(this.cipherSuites, other.cipherSuites)) {
            return false;
        }
        return Objects.equals(this.sessionId, other.sessionId);
    }
}

