/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bool.ModifiableBoolean;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.SSL2MessageType;
import de.rub.nds.tlsattacker.core.layer.Message;
import de.rub.nds.tlsattacker.core.protocol.handler.SSL2MessageHandler;
import de.rub.nds.tlsattacker.core.protocol.parser.SSL2MessageParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.SSL2MessagePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.SSL2MessageSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.InputStream;
import java.util.List;

public abstract class SSL2Message
extends Message {
    @XmlTransient
    protected boolean goingToBeSentDefault = true;
    @XmlTransient
    protected boolean requiredDefault = true;
    @XmlTransient
    protected boolean adjustContextDefault = true;
    @XmlTransient
    protected boolean shouldPrepareDefault = true;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger messageLength;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger paddingLength;
    @ModifiableVariableProperty
    protected ModifiableByteArray completeResultingMessage;
    @ModifiableVariableProperty
    private ModifiableBoolean required;
    @ModifiableVariableProperty
    private ModifiableBoolean goingToBeSent;
    @ModifiableVariableProperty
    private ModifiableBoolean adjustContext;
    @XmlTransient
    protected ProtocolMessageType protocolMessageType;
    private ModifiableByte type = null;
    @XmlTransient
    private SSL2MessageType ssl2MessageType;

    public SSL2Message(SSL2MessageType ssl2MessageType) {
        this.ssl2MessageType = ssl2MessageType;
    }

    public ModifiableInteger getMessageLength() {
        return this.messageLength;
    }

    public void setMessageLength(ModifiableInteger messageLength) {
        this.messageLength = messageLength;
    }

    public void setMessageLength(Integer messageLength) {
        this.messageLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.messageLength, (Integer)messageLength);
    }

    public ModifiableInteger getPaddingLength() {
        return this.paddingLength;
    }

    public void setPaddingLength(ModifiableInteger paddingLength) {
        this.paddingLength = paddingLength;
    }

    public void setPaddingLength(Integer paddingLength) {
        this.paddingLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.paddingLength, (Integer)paddingLength);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.getType() != null && this.getType().getValue() != null) {
            sb.append("\n Type: ").append(this.getType().getValue());
        }
        return sb.toString();
    }

    public ModifiableByte getType() {
        return this.type;
    }

    public void setType(ModifiableByte type) {
        this.type = type;
    }

    public void setType(Byte type) {
        this.type = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.type, (Byte)type);
    }

    public SSL2MessageType getSsl2MessageType() {
        return this.ssl2MessageType;
    }

    public void setSsl2MessageType(SSL2MessageType ssl2MessageType) {
        this.ssl2MessageType = ssl2MessageType;
    }

    public boolean addToTypes(List<ProtocolMessageType> protocolMessageTypes) {
        return protocolMessageTypes.add(this.getProtocolMessageType());
    }

    public void setShouldPrepareDefault(boolean shouldPrepare) {
        this.shouldPrepareDefault = shouldPrepare;
    }

    @Override
    public boolean shouldPrepare() {
        return this.shouldPrepareDefault;
    }

    @Override
    public boolean isRequired() {
        if (this.required == null) {
            return this.requiredDefault;
        }
        if (this.required.getValue() == null) {
            this.required.setOriginalValue(Boolean.valueOf(this.requiredDefault));
        }
        return (Boolean)this.required.getValue();
    }

    public void setRequired(boolean required) {
        this.required = ModifiableVariableFactory.safelySetValue((ModifiableBoolean)this.required, (Boolean)required);
    }

    public boolean isGoingToBeSent() {
        if (this.goingToBeSent == null) {
            return this.goingToBeSentDefault;
        }
        if (this.goingToBeSent.getValue() == null) {
            this.goingToBeSent.setOriginalValue(Boolean.valueOf(this.goingToBeSentDefault));
        }
        return (Boolean)this.goingToBeSent.getValue();
    }

    public void setGoingToBeSent(boolean goingToBeSent) {
        this.goingToBeSent = ModifiableVariableFactory.safelySetValue((ModifiableBoolean)this.goingToBeSent, (Boolean)goingToBeSent);
    }

    public void setGoingToBeSent(ModifiableBoolean goingToBeSent) {
        this.goingToBeSent = goingToBeSent;
    }

    public ModifiableByteArray getCompleteResultingMessage() {
        return this.completeResultingMessage;
    }

    public void setCompleteResultingMessage(ModifiableByteArray completeResultingMessage) {
        this.completeResultingMessage = completeResultingMessage;
    }

    public void setCompleteResultingMessage(byte[] completeResultingMessage) {
        this.completeResultingMessage = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.completeResultingMessage, (byte[])completeResultingMessage);
    }

    public boolean getAdjustContext() {
        if (this.adjustContext == null) {
            return this.adjustContextDefault;
        }
        if (this.adjustContext.getValue() == null) {
            this.adjustContext.setOriginalValue(Boolean.valueOf(this.adjustContextDefault));
        }
        return (Boolean)this.adjustContext.getValue();
    }

    public void setAdjustContext(ModifiableBoolean adjustContext) {
        this.adjustContext = adjustContext;
    }

    public void setAdjustContext(Boolean adjustContext) {
        this.adjustContext = ModifiableVariableFactory.safelySetValue((ModifiableBoolean)this.adjustContext, (Boolean)adjustContext);
    }

    public ProtocolMessageType getProtocolMessageType() {
        return this.protocolMessageType;
    }

    public abstract SSL2MessageHandler<? extends SSL2Message> getHandler(Context var1);

    public abstract SSL2MessageParser<? extends SSL2Message> getParser(Context var1, InputStream var2);

    public abstract SSL2MessagePreparator<? extends SSL2Message> getPreparator(Context var1);

    public abstract SSL2MessageSerializer<? extends SSL2Message> getSerializer(Context var1);
}

