/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.handler.RSAServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.RSAServerComputations;
import de.rub.nds.tlsattacker.core.protocol.parser.RSAServerKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.RSAServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.RSAServerKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.List;

@XmlRootElement(name="RSAServerKeyExchange")
public class RSAServerKeyExchangeMessage
extends ServerKeyExchangeMessage {
    @ModifiableVariableProperty
    protected ModifiableByteArray modulus;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    protected ModifiableInteger modulusLength;
    @HoldsModifiableVariable
    protected RSAServerComputations computations;

    @Override
    public RSAServerComputations getKeyExchangeComputations() {
        return this.computations;
    }

    @Override
    public void prepareKeyExchangeComputations() {
        if (this.getKeyExchangeComputations() == null) {
            this.computations = new RSAServerComputations();
        }
    }

    @Override
    public RSAServerKeyExchangeHandler getHandler(Context context) {
        return new RSAServerKeyExchangeHandler(context.getTlsContext());
    }

    @Override
    public RSAServerKeyExchangeParser<RSAServerKeyExchangeMessage> getParser(Context context, InputStream stream) {
        return new RSAServerKeyExchangeParser<RSAServerKeyExchangeMessage>(stream, context.getTlsContext());
    }

    @Override
    public RSAServerKeyExchangePreparator<RSAServerKeyExchangeMessage> getPreparator(Context context) {
        return new RSAServerKeyExchangePreparator<RSAServerKeyExchangeMessage>(context.getChooser(), this);
    }

    @Override
    public RSAServerKeyExchangeSerializer<RSAServerKeyExchangeMessage> getSerializer(Context context) {
        return new RSAServerKeyExchangeSerializer<RSAServerKeyExchangeMessage>(this, context.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RSAServerKeyExchangeMessage:");
        sb.append("\n  Modulus N: ");
        if (this.modulus != null && this.modulus.getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.modulus.getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Public Key e: ");
        if (this.getPublicKey() != null && this.getPublicKey().getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getPublicKey().getValue()), (boolean)false));
        } else {
            sb.append("null");
        }
        sb.append("\n  Signature and Hash Algorithm: ");
        if (this.getSignatureAndHashAlgorithm() != null && this.getSignatureAndHashAlgorithm().getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getSignatureAndHashAlgorithm().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Signature: ");
        if (this.getSignature() != null && this.getSignature().getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getSignature().getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RSA_SERVER_KEY_EXCHANGE");
        if (this.isRetransmission()) {
            sb.append(" (ret.)");
        }
        return sb.toString();
    }

    @Override
    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List<ModifiableVariableHolder> holders = super.getAllModifiableVariableHolders();
        if (this.computations != null) {
            holders.add(this.computations);
        }
        return holders;
    }

    public ModifiableByteArray getModulus() {
        return this.modulus;
    }

    public void setModulus(byte[] modulus) {
        this.modulus = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.modulus, (byte[])modulus);
    }

    public void setModulus(ModifiableByteArray modulus) {
        this.modulus = modulus;
    }

    public void setModulusLength(ModifiableInteger modulusLength) {
        this.modulusLength = modulusLength;
    }

    public ModifiableInteger getModulusLength() {
        return this.modulusLength;
    }

    public void setModulusLength(int modulusLength) {
        this.modulusLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.modulusLength, (Integer)modulusLength);
    }
}

