/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.ConnectionIdUsage;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.NewConnectionIdHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.connectionid.ConnectionId;
import de.rub.nds.tlsattacker.core.protocol.parser.NewConnectionIdParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.NewConnectionIdPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.NewConnectionIdSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="NewConnectionId")
public class NewConnectionIdMessage
extends HandshakeMessage {
    @ModifiableVariableProperty
    private ConnectionIdUsage usage;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger connectionIdsLength;
    @HoldsModifiableVariable
    private List<ConnectionId> connectionIds;

    public NewConnectionIdMessage() {
        super(HandshakeMessageType.NEW_CONNECTION_ID);
    }

    @Override
    public NewConnectionIdParser getParser(Context context, InputStream stream) {
        return new NewConnectionIdParser(stream, context.getTlsContext());
    }

    @Override
    public NewConnectionIdPreparator getPreparator(Context context) {
        return new NewConnectionIdPreparator(context.getChooser(), this);
    }

    @Override
    public NewConnectionIdSerializer getSerializer(Context context) {
        return new NewConnectionIdSerializer(this);
    }

    @Override
    public NewConnectionIdHandler getHandler(Context context) {
        return new NewConnectionIdHandler(context.getTlsContext());
    }

    public ConnectionIdUsage getUsage() {
        return this.usage;
    }

    public void setUsage(ConnectionIdUsage usage) {
        this.usage = usage;
    }

    public ModifiableInteger getConnectionIdsLength() {
        return this.connectionIdsLength;
    }

    public void setConnectionIdsLength(Integer connectionIdsLength) {
        this.connectionIdsLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.connectionIdsLength, (Integer)connectionIdsLength);
    }

    public List<ConnectionId> getConnectionIds() {
        return this.connectionIds;
    }

    public void setConnectionIdsLength(ModifiableInteger connectionIdsLength) {
        this.connectionIdsLength = connectionIdsLength;
    }

    public void setConnectionIds(List<ConnectionId> connectionIds) {
        this.connectionIds = connectionIds;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode((Object)this.usage);
        hash = 79 * hash + Objects.hashCode(this.connectionIdsLength);
        hash = 79 * hash + Objects.hashCode(this.connectionIds);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewConnectionIdMessage other = (NewConnectionIdMessage)obj;
        if (this.usage != other.usage) {
            return false;
        }
        if (!Objects.equals(this.connectionIdsLength, other.connectionIdsLength)) {
            return false;
        }
        return Objects.equals(this.connectionIds, other.connectionIds);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NewConnectionId:");
        sb.append("\n  Usage: ");
        if (this.usage != null) {
            sb.append((Object)this.usage);
        } else {
            sb.append("null");
        }
        sb.append("\n  ConnectionIds: ");
        if (this.connectionIds != null && !this.connectionIds.isEmpty()) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.connectionIds.get(0).getConnectionId().getValue())));
            for (int i = 1; i < this.connectionIds.size(); ++i) {
                sb.append(", ");
                sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.connectionIds.get(i).getConnectionId().getValue())));
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "NCID";
    }
}

