/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.KeyExchangeComputations;
import java.util.Objects;

public abstract class ClientKeyExchangeMessage
extends HandshakeMessage {
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger publicKeyLength;
    @ModifiableVariableProperty
    private ModifiableByteArray publicKey;

    protected ClientKeyExchangeMessage() {
        super(HandshakeMessageType.CLIENT_KEY_EXCHANGE);
    }

    public abstract KeyExchangeComputations getComputations();

    public abstract void prepareComputations();

    public ModifiableInteger getPublicKeyLength() {
        return this.publicKeyLength;
    }

    public void setPublicKeyLength(ModifiableInteger publicKeyLength) {
        this.publicKeyLength = publicKeyLength;
    }

    public void setPublicKeyLength(Integer publicKeyLength) {
        this.publicKeyLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.publicKeyLength, (Integer)publicKeyLength);
    }

    public ModifiableByteArray getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(ModifiableByteArray publicKey) {
        this.publicKey = publicKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.publicKey, (byte[])publicKey);
    }

    @Override
    public String toShortString() {
        return "CKE";
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientKeyExchangeMessage other = (ClientKeyExchangeMessage)obj;
        if (!Objects.equals(this.publicKeyLength, other.publicKeyLength)) {
            return false;
        }
        return Objects.equals(this.publicKey, other.publicKey);
    }
}

