/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ClientCertificateType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.protocol.handler.CertificateRequestHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignatureAlgorithmsCertExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignatureAndHashAlgorithmsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.CertificateRequestParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.CertificateRequestPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.CertificateRequestSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="CertificateRequest")
public class CertificateRequestMessage
extends HandshakeMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    @ModifiableVariableProperty
    private ModifiableInteger clientCertificateTypesCount;
    @ModifiableVariableProperty
    private ModifiableByteArray clientCertificateTypes;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger signatureHashAlgorithmsLength;
    @ModifiableVariableProperty
    private ModifiableByteArray signatureHashAlgorithms;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger distinguishedNamesLength;
    @ModifiableVariableProperty
    private ModifiableByteArray distinguishedNames;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger certificateRequestContextLength;
    @ModifiableVariableProperty
    private ModifiableByteArray certificateRequestContext;

    public CertificateRequestMessage() {
        super(HandshakeMessageType.CERTIFICATE_REQUEST);
    }

    public CertificateRequestMessage(Config tlsConfig) {
        super(HandshakeMessageType.CERTIFICATE_REQUEST);
        if (tlsConfig.getHighestProtocolVersion().is13()) {
            this.setExtensions(new LinkedList<ExtensionMessage>());
            this.addExtension(new SignatureAndHashAlgorithmsExtensionMessage());
        }
        if (tlsConfig.isAddSignatureAlgorithmsCertExtension().booleanValue()) {
            this.addExtension(new SignatureAlgorithmsCertExtensionMessage());
        }
    }

    public ModifiableInteger getClientCertificateTypesCount() {
        return this.clientCertificateTypesCount;
    }

    public void setClientCertificateTypesCount(ModifiableInteger clientCertificateTypesCount) {
        this.clientCertificateTypesCount = clientCertificateTypesCount;
    }

    public void setClientCertificateTypesCount(int clientCertificateTypesCount) {
        this.clientCertificateTypesCount = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.clientCertificateTypesCount, (Integer)clientCertificateTypesCount);
    }

    public ModifiableByteArray getClientCertificateTypes() {
        return this.clientCertificateTypes;
    }

    public void setClientCertificateTypes(ModifiableByteArray clientCertificateTypes) {
        this.clientCertificateTypes = clientCertificateTypes;
    }

    public void setClientCertificateTypes(byte[] clientCertificateTypes) {
        this.clientCertificateTypes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.clientCertificateTypes, (byte[])clientCertificateTypes);
    }

    public ModifiableInteger getSignatureHashAlgorithmsLength() {
        return this.signatureHashAlgorithmsLength;
    }

    public void setSignatureHashAlgorithmsLength(ModifiableInteger signatureHashAlgorithmsLength) {
        this.signatureHashAlgorithmsLength = signatureHashAlgorithmsLength;
    }

    public void setSignatureHashAlgorithmsLength(int signatureHashAlgorithmsLength) {
        this.signatureHashAlgorithmsLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.signatureHashAlgorithmsLength, (Integer)signatureHashAlgorithmsLength);
    }

    public ModifiableByteArray getSignatureHashAlgorithms() {
        return this.signatureHashAlgorithms;
    }

    public void setSignatureHashAlgorithms(ModifiableByteArray signatureHashAlgorithms) {
        this.signatureHashAlgorithms = signatureHashAlgorithms;
    }

    public void setSignatureHashAlgorithms(byte[] signatureHashAlgorithms) {
        this.signatureHashAlgorithms = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.signatureHashAlgorithms, (byte[])signatureHashAlgorithms);
    }

    public ModifiableInteger getDistinguishedNamesLength() {
        return this.distinguishedNamesLength;
    }

    public void setDistinguishedNamesLength(ModifiableInteger distinguishedNamesLength) {
        this.distinguishedNamesLength = distinguishedNamesLength;
    }

    public void setDistinguishedNamesLength(int distinguishedNamesLength) {
        this.distinguishedNamesLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.distinguishedNamesLength, (Integer)distinguishedNamesLength);
    }

    public ModifiableByteArray getDistinguishedNames() {
        return this.distinguishedNames;
    }

    public void setDistinguishedNames(ModifiableByteArray distinguishedNames) {
        this.distinguishedNames = distinguishedNames;
    }

    public void setDistinguishedNames(byte[] distinguishedNames) {
        this.distinguishedNames = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.distinguishedNames, (byte[])distinguishedNames);
    }

    public ModifiableInteger getCertificateRequestContextLength() {
        return this.certificateRequestContextLength;
    }

    public void setCertificateRequestContextLength(ModifiableInteger certificateRequestContextLength) {
        this.certificateRequestContextLength = certificateRequestContextLength;
    }

    public void setCertificateRequestContextLength(int certificateRequestContextLength) {
        this.certificateRequestContextLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.certificateRequestContextLength, (Integer)certificateRequestContextLength);
    }

    public ModifiableByteArray getCertificateRequestContext() {
        return this.certificateRequestContext;
    }

    public void setCertificateRequestContext(ModifiableByteArray certificateRequestContext) {
        this.certificateRequestContext = certificateRequestContext;
    }

    public void setCertificateRequestContext(byte[] certificateRequestContext) {
        this.certificateRequestContext = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.certificateRequestContext, (byte[])certificateRequestContext);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CertificateRequestMessage:");
        sb.append("\n  Certificate Types Count: ");
        if (this.clientCertificateTypesCount != null && this.clientCertificateTypesCount.getValue() != null) {
            sb.append(this.clientCertificateTypesCount.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Certificate Types: ");
        if (this.clientCertificateTypes != null && this.clientCertificateTypes.getValue() != null) {
            for (int i = 0; i < ((byte[])this.clientCertificateTypes.getValue()).length; ++i) {
                sb.append((Object)ClientCertificateType.getClientCertificateType(((byte[])this.clientCertificateTypes.getValue())[i])).append(", ");
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  Signature Hash Algorithms Length: ");
        if (this.signatureHashAlgorithmsLength != null && this.signatureHashAlgorithmsLength.getValue() != null) {
            sb.append(this.signatureHashAlgorithmsLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Signature Hash Algorithms: ");
        if (this.signatureHashAlgorithms != null && this.signatureHashAlgorithms.getValue() != null) {
            try {
                List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms = SignatureAndHashAlgorithm.getSignatureAndHashAlgorithms((byte[])this.signatureHashAlgorithms.getValue());
                for (SignatureAndHashAlgorithm algo : signatureAndHashAlgorithms) {
                    sb.append(algo.name());
                    sb.append(", ");
                }
            }
            catch (Exception e) {
                LOGGER.debug((Object)e);
                LOGGER.debug("Signature and HashAlgorithms contain unparseable Algorithms: {}", (Object)this.signatureHashAlgorithms);
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  Distinguished Names Length: ");
        if (this.distinguishedNamesLength != null && this.distinguishedNamesLength.getValue() != null) {
            sb.append(this.distinguishedNamesLength.getValue());
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "CR";
    }

    @Override
    public CertificateRequestHandler getHandler(Context context) {
        return new CertificateRequestHandler(context.getTlsContext());
    }

    @Override
    public CertificateRequestParser getParser(Context context, InputStream stream) {
        return new CertificateRequestParser(stream, context.getTlsContext());
    }

    @Override
    public CertificateRequestPreparator getPreparator(Context context) {
        return new CertificateRequestPreparator(context.getChooser(), this);
    }

    @Override
    public CertificateRequestSerializer getSerializer(Context context) {
        return new CertificateRequestSerializer(this, context.getChooser().getSelectedProtocolVersion());
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Objects.hashCode(this.clientCertificateTypesCount);
        hash = 61 * hash + Objects.hashCode(this.clientCertificateTypes);
        hash = 61 * hash + Objects.hashCode(this.signatureHashAlgorithmsLength);
        hash = 61 * hash + Objects.hashCode(this.signatureHashAlgorithms);
        hash = 61 * hash + Objects.hashCode(this.distinguishedNamesLength);
        hash = 61 * hash + Objects.hashCode(this.distinguishedNames);
        hash = 61 * hash + Objects.hashCode(this.certificateRequestContextLength);
        hash = 61 * hash + Objects.hashCode(this.certificateRequestContext);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateRequestMessage other = (CertificateRequestMessage)obj;
        if (!Objects.equals(this.clientCertificateTypesCount, other.clientCertificateTypesCount)) {
            return false;
        }
        if (!Objects.equals(this.clientCertificateTypes, other.clientCertificateTypes)) {
            return false;
        }
        if (!Objects.equals(this.signatureHashAlgorithmsLength, other.signatureHashAlgorithmsLength)) {
            return false;
        }
        if (!Objects.equals(this.signatureHashAlgorithms, other.signatureHashAlgorithms)) {
            return false;
        }
        if (!Objects.equals(this.distinguishedNamesLength, other.distinguishedNamesLength)) {
            return false;
        }
        if (!Objects.equals(this.distinguishedNames, other.distinguishedNames)) {
            return false;
        }
        if (!Objects.equals(this.certificateRequestContextLength, other.certificateRequestContextLength)) {
            return false;
        }
        return Objects.equals(this.certificateRequestContext, other.certificateRequestContext);
    }
}

