/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageParser;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessagePreparator;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageSerializer;
import de.rub.nds.tlsattacker.core.protocol.handler.AckHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ack.RecordNumber;
import de.rub.nds.tlsattacker.core.protocol.parser.AckParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.AckPreperator;
import de.rub.nds.tlsattacker.core.protocol.serializer.AckSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="Ack")
public class AckMessage
extends ProtocolMessage {
    private List<RecordNumber> recordNumbers;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger recordNumberLength;

    public List<RecordNumber> getRecordNumbers() {
        return this.recordNumbers;
    }

    public void setRecordNumbers(List<RecordNumber> recordNumbers) {
        this.recordNumbers = recordNumbers;
    }

    public void setRecordNumberLength(ModifiableInteger recordNumberLength) {
        this.recordNumberLength = recordNumberLength;
    }

    public ModifiableInteger getRecordNumberLength() {
        return this.recordNumberLength;
    }

    public void setRecordNumberLength(int recordNumberLength) {
        this.recordNumberLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.recordNumberLength, (Integer)recordNumberLength);
    }

    public AckMessage() {
        this.protocolMessageType = ProtocolMessageType.ACK;
    }

    @Override
    public String toCompactString() {
        return "ACK";
    }

    @Override
    public String toShortString() {
        return "ACK";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ACK Message");
        sb.append("\t Acknowledged record numbers: \n");
        if (this.recordNumbers != null) {
            for (RecordNumber recordNumber : this.recordNumbers) {
                sb.append("\t - Epoch ").append(recordNumber.getEpoch().getValue());
                sb.append(" | SQN ").append(recordNumber.getSequenceNumber().getValue());
            }
        }
        return sb.toString();
    }

    @Override
    public ProtocolMessageHandler<AckMessage> getHandler(Context context) {
        return new AckHandler(context);
    }

    @Override
    public ProtocolMessageSerializer<AckMessage> getSerializer(Context context) {
        return new AckSerializer(this);
    }

    @Override
    public ProtocolMessagePreparator<AckMessage> getPreparator(Context context) {
        return new AckPreperator(context.getChooser(), this, context.getTlsContext());
    }

    @Override
    public ProtocolMessageParser<AckMessage> getParser(Context tlsContext, InputStream stream) {
        return new AckParser(stream);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.recordNumbers);
        hash = 61 * hash + Objects.hashCode(this.recordNumberLength);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AckMessage other = (AckMessage)obj;
        if (!Objects.equals(this.recordNumbers, other.recordNumbers)) {
            return false;
        }
        return Objects.equals(this.recordNumberLength, other.recordNumberLength);
    }
}

