/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.protocol.exception.AdjustmentException;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SupportedVersionsExtensionMessage;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SupportedVersionsExtensionHandler
extends ExtensionHandler<SupportedVersionsExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SupportedVersionsExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(SupportedVersionsExtensionMessage message) {
        byte[] versionBytes = (byte[])message.getSupportedVersions().getValue();
        if (versionBytes.length % 2 != 0) {
            throw new AdjustmentException("Could not create reasonable ProtocolVersions from VersionBytes");
        }
        List<ProtocolVersion> versionList = ProtocolVersion.getProtocolVersions(versionBytes);
        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.tlsContext.setClientSupportedProtocolVersions(versionList);
            this.tlsContext.setHighestClientProtocolVersion(ProtocolVersion.getHighestProtocolVersion(versionList));
        } else {
            if (this.tlsContext.getConfig().isEnforceSettings().booleanValue()) {
                this.tlsContext.setSelectedProtocolVersion(this.tlsContext.getChooser().getHighestProtocolVersion());
                return;
            }
            if (versionList.size() == 1) {
                this.tlsContext.setSelectedProtocolVersion(versionList.get(0));
            } else {
                LOGGER.warn("Received a SupportedProtocolVersionExtension with unknown contents");
            }
        }
    }
}

