/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Handler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExtensionHandler<ExtensionT extends ExtensionMessage>
extends Handler<ExtensionT> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final TlsContext tlsContext;

    public ExtensionHandler(TlsContext tlsContext) {
        this.tlsContext = tlsContext;
    }

    @Override
    public final void adjustContext(ExtensionT message) {
        this.markExtensionInContext(message);
        this.adjustTLSExtensionContext(message);
    }

    public abstract void adjustTLSExtensionContext(ExtensionT var1);

    private void markExtensionInContext(ExtensionT message) {
        ExtensionType extType = ((ExtensionMessage)message).getExtensionTypeConstant();
        ConnectionEndType talkingConEndType = this.tlsContext.getTalkingConnectionEndType();
        if (talkingConEndType == ConnectionEndType.CLIENT) {
            this.tlsContext.addProposedExtension(extType);
            LOGGER.debug("Marked extension '{}' as proposed", (Object)extType.name());
        } else if (talkingConEndType == ConnectionEndType.SERVER) {
            this.tlsContext.addNegotiatedExtension(extType);
            LOGGER.debug("Marked extension '{}' as negotiated", (Object)extType.name());
        }
    }
}

