/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.protocol.exception.AdjustmentException;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EllipticCurvesExtensionMessage;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EllipticCurvesExtensionHandler
extends ExtensionHandler<EllipticCurvesExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EllipticCurvesExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(EllipticCurvesExtensionMessage message) {
        byte[] groupBytes = (byte[])message.getSupportedGroups().getValue();
        if (groupBytes.length % 2 != 0) {
            throw new AdjustmentException("Could not create reasonable NamedGroups from groupBytes");
        }
        LinkedList<NamedGroup> groupList = new LinkedList<NamedGroup>();
        for (int i = 0; i < groupBytes.length; i += 2) {
            byte[] group = Arrays.copyOfRange(groupBytes, i, i + 2);
            NamedGroup namedGroup = NamedGroup.getNamedGroup(group);
            if (namedGroup == null) {
                LOGGER.warn("Unknown EllipticCurve: {}", (Object)group);
                continue;
            }
            groupList.add(namedGroup);
        }
        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.tlsContext.setClientNamedGroupsList(groupList);
        } else {
            this.tlsContext.setServerNamedGroupsList(groupList);
        }
    }
}

