/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ECPointFormatExtensionMessage;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECPointFormatExtensionHandler
extends ExtensionHandler<ECPointFormatExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ECPointFormatExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public void adjustTLSExtensionContext(ECPointFormatExtensionMessage message) {
        byte[] pointFormats;
        LinkedList<ECPointFormat> formatList = new LinkedList<ECPointFormat>();
        for (byte b : pointFormats = (byte[])message.getPointFormats().getValue()) {
            ECPointFormat format = ECPointFormat.getECPointFormat(b);
            if (format != null) {
                formatList.add(format);
                continue;
            }
            LOGGER.warn("Unknown ECPointFormat: {}", (Object)b);
        }
        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.tlsContext.setClientPointFormatsList(formatList);
        } else {
            this.tlsContext.setServerPointFormatsList(formatList);
        }
    }
}

