/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.CertificateStatusRequestType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestExtensionMessage;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateStatusRequestExtensionHandler
extends ExtensionHandler<CertificateStatusRequestExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificateStatusRequestExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(CertificateStatusRequestExtensionMessage message) {
        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.tlsContext.setCertificateStatusRequestExtensionRequestType(CertificateStatusRequestType.getCertificateStatusRequestType((Integer)message.getCertificateStatusRequestType().getValue()));
            LOGGER.debug("Adjusted the Certificate Status Request Type in the TLSContext to {}", (Object)this.tlsContext.getCertificateStatusRequestExtensionRequestType());
            this.tlsContext.setCertificateStatusRequestExtensionRequestExtension((byte[])message.getRequestExtension().getValue());
            LOGGER.debug("Adjusted the Certificate Status Request Request Extension to {}", (Object)this.tlsContext.getCertificateStatusRequestExtensionRequestExtension());
            this.tlsContext.setCertificateStatusRequestExtensionResponderIDList((byte[])message.getResponderIDList().getValue());
            LOGGER.debug("Adjusted the Certificate Status Request Responder ID List to {}", (Object)this.tlsContext.getCertificateStatusRequestExtensionResponderIDList());
        }
    }
}

