/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.ConnectionIdUsage;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.NewConnectionIdMessage;

public class NewConnectionIdHandler
extends HandshakeMessageHandler<NewConnectionIdMessage> {
    public NewConnectionIdHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(NewConnectionIdMessage message) {
        if (this.tlsContext.getTalkingConnectionEndType() != this.tlsContext.getConnection().getLocalConnectionEndType() && message.getConnectionIds() != null && !message.getConnectionIds().isEmpty()) {
            this.tlsContext.addNewWriteConnectionId((byte[])message.getConnectionIds().get(0).getConnectionId().getValue(), message.getUsage() == ConnectionIdUsage.CID_SPARE);
            for (int i = 1; i < message.getConnectionIds().size(); ++i) {
                this.tlsContext.addNewWriteConnectionId((byte[])message.getConnectionIds().get(i).getConnectionId().getValue(), true);
            }
        }
    }
}

