/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.AdjustmentException;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.layer.constant.StackConfiguration;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.NewSessionTicketHandler;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ack.RecordNumber;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacketCryptoComputations;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeyDerivator;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FinishedHandler
extends HandshakeMessageHandler<FinishedMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public FinishedHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(FinishedMessage message) {
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().is13()) {
            if (this.tlsContext.getTalkingConnectionEndType() != this.tlsContext.getChooser().getConnectionEndType()) {
                if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
                    this.adjustApplicationTrafficSecrets();
                    this.setServerRecordCipher(Tls13KeySetType.APPLICATION_TRAFFIC_SECRETS);
                    if (this.tlsContext.getConfig().getDefaultLayerConfiguration() == StackConfiguration.QUIC) {
                        try {
                            QuicPacketCryptoComputations.calculateApplicationSecrets(this.tlsContext.getContext());
                        }
                        catch (CryptoException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                            LOGGER.error("Could not initialize application secrets: ", e);
                        }
                    }
                    if (!this.tlsContext.isExtensionNegotiated(ExtensionType.EARLY_DATA)) {
                        this.setClientRecordCipher(Tls13KeySetType.HANDSHAKE_TRAFFIC_SECRETS);
                    }
                } else {
                    if (this.tlsContext.getChooser().getSelectedProtocolVersion().isDTLS13()) {
                        this.acknowledgeFinished();
                    }
                    this.setClientRecordCipher(Tls13KeySetType.APPLICATION_TRAFFIC_SECRETS);
                }
            } else if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.SERVER && !this.tlsContext.isExtensionNegotiated(ExtensionType.EARLY_DATA)) {
                this.setClientRecordCipher(Tls13KeySetType.HANDSHAKE_TRAFFIC_SECRETS);
                if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
                    NewSessionTicketHandler ticketHandler = new NewSessionTicketHandler(this.tlsContext);
                    if (this.tlsContext.getPskSets() != null) {
                        for (PskSet pskSet : this.tlsContext.getPskSets()) {
                            if (pskSet.getPreSharedKey() != null) continue;
                            pskSet.setPreSharedKey(ticketHandler.derivePsk(pskSet));
                        }
                    }
                }
            }
        }
        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.tlsContext.setLastClientVerifyData((byte[])message.getVerifyData().getValue());
        } else {
            this.tlsContext.setLastServerVerifyData((byte[])message.getVerifyData().getValue());
        }
    }

    private void acknowledgeFinished() {
        this.tlsContext.setDtls13AcknowledgedRecords(new LinkedList<RecordNumber>());
        int epoch = this.tlsContext.getReadEpoch();
        long readSequenceNumber = this.tlsContext.getReadSequenceNumber(epoch);
        for (long sequenceNumber = 0L; sequenceNumber < readSequenceNumber; ++sequenceNumber) {
            RecordNumber recordNumber = new RecordNumber(BigInteger.valueOf(epoch), BigInteger.valueOf(sequenceNumber));
            this.tlsContext.getDtls13AcknowledgedRecords().add(recordNumber);
        }
    }

    private void adjustApplicationTrafficSecrets() {
        HKDFAlgorithm hkdfAlgorithm = AlgorithmResolver.getHKDFAlgorithm(this.tlsContext.getChooser().getSelectedCipherSuite());
        DigestAlgorithm digestAlgo = AlgorithmResolver.getDigestAlgorithm(this.tlsContext.getChooser().getSelectedProtocolVersion(), this.tlsContext.getChooser().getSelectedCipherSuite());
        try {
            int macLength = hkdfAlgorithm.getMacAlgorithm().getJavaName().equals("HmacSM3") ? 32 : Mac.getInstance(hkdfAlgorithm.getMacAlgorithm().getJavaName()).getMacLength();
            byte[] saltMasterSecret = HKDFunction.deriveSecret(hkdfAlgorithm, digestAlgo.getJavaName(), this.tlsContext.getChooser().getHandshakeSecret(), "derived", DataConverter.hexStringToByteArray((String)""), this.tlsContext.getChooser().getSelectedProtocolVersion());
            byte[] masterSecret = HKDFunction.extract(hkdfAlgorithm, saltMasterSecret, new byte[macLength]);
            byte[] clientApplicationTrafficSecret = HKDFunction.deriveSecret(hkdfAlgorithm, digestAlgo.getJavaName(), masterSecret, "c ap traffic", this.tlsContext.getDigest().getRawBytes(), this.tlsContext.getChooser().getSelectedProtocolVersion());
            this.tlsContext.setClientApplicationTrafficSecret(clientApplicationTrafficSecret);
            LOGGER.debug("Set clientApplicationTrafficSecret in Context to {}", (Object)clientApplicationTrafficSecret);
            byte[] serverApplicationTrafficSecret = HKDFunction.deriveSecret(hkdfAlgorithm, digestAlgo.getJavaName(), masterSecret, "s ap traffic", this.tlsContext.getDigest().getRawBytes(), this.tlsContext.getChooser().getSelectedProtocolVersion());
            this.tlsContext.setServerApplicationTrafficSecret(serverApplicationTrafficSecret);
            LOGGER.debug("Set serverApplicationTrafficSecret in Context to {}", (Object)serverApplicationTrafficSecret);
            this.tlsContext.setMasterSecret(masterSecret);
            LOGGER.debug("Set masterSecret in Context to {}", (Object)masterSecret);
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            throw new AdjustmentException(ex);
        }
    }

    @Override
    public void adjustContextAfterSerialize(FinishedMessage message) {
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().is13()) {
            if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.CLIENT) {
                this.setClientRecordCipher(Tls13KeySetType.APPLICATION_TRAFFIC_SECRETS);
            } else {
                this.adjustApplicationTrafficSecrets();
                this.setServerRecordCipher(Tls13KeySetType.APPLICATION_TRAFFIC_SECRETS);
            }
        }
    }

    private KeySet getKeySet(TlsContext tlsContext, Tls13KeySetType keySetType) {
        try {
            LOGGER.debug("Generating new KeySet");
            KeySet keySet = KeyDerivator.generateKeySet(tlsContext, tlsContext.getChooser().getSelectedProtocolVersion(), keySetType);
            return keySet;
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("The specified Algorithm is not supported", ex);
        }
    }

    private void setServerRecordCipher(Tls13KeySetType keySetType) {
        this.tlsContext.setActiveServerKeySetType(keySetType);
        LOGGER.debug("Setting cipher for server to use {}", (Object)keySetType);
        KeySet serverKeySet = this.getKeySet(this.tlsContext, this.tlsContext.getActiveServerKeySetType());
        if (this.tlsContext.getRecordLayer() != null) {
            if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.CLIENT) {
                this.tlsContext.getRecordLayer().updateDecryptionCipher(RecordCipherFactory.getRecordCipher(this.tlsContext, serverKeySet, false));
            } else {
                this.tlsContext.getRecordLayer().updateEncryptionCipher(RecordCipherFactory.getRecordCipher(this.tlsContext, serverKeySet, true));
            }
        }
    }

    private void setClientRecordCipher(Tls13KeySetType keySetType) {
        this.tlsContext.setActiveClientKeySetType(keySetType);
        LOGGER.debug("Setting cipher for client to use {}", (Object)keySetType);
        KeySet clientKeySet = this.getKeySet(this.tlsContext, this.tlsContext.getActiveClientKeySetType());
        if (this.tlsContext.getRecordLayer() != null) {
            if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.SERVER) {
                this.tlsContext.getRecordLayer().updateDecryptionCipher(RecordCipherFactory.getRecordCipher(this.tlsContext, clientKeySet, false));
            } else {
                this.tlsContext.getRecordLayer().updateEncryptionCipher(RecordCipherFactory.getRecordCipher(this.tlsContext, clientKeySet, true));
            }
        }
    }
}

