/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.ClientKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHClientKeyExchangeHandler<KeyExchangeMessage extends ECDHClientKeyExchangeMessage>
extends ClientKeyExchangeHandler<KeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ECDHClientKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(KeyExchangeMessage message) {
        this.adjustPremasterSecret(message);
        this.adjustMasterSecret(message);
        this.adjustClientPublicKey(message);
        this.spawnNewSession();
    }

    private void adjustClientPublicKey(KeyExchangeMessage message) {
        byte[] serializedPoint = (byte[])((ClientKeyExchangeMessage)message).getPublicKey().getValue();
        NamedGroup usedGroup = this.tlsContext.getChooser().getSelectedNamedGroup();
        LOGGER.debug("Adjusting EC Point");
        Point publicKey = PointFormatter.formatFromByteArray(usedGroup.getGroupParameters(), (byte[])serializedPoint);
        this.tlsContext.setClientEphemeralEcPublicKey(publicKey);
    }
}

