/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.protocol.constants.FfdhGroupParameters;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.ServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.DHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DHEServerKeyExchangeHandler<KeyExchangeMessage extends DHEServerKeyExchangeMessage>
extends ServerKeyExchangeHandler<KeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public DHEServerKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(KeyExchangeMessage message) {
        this.adjustDhGenerator(message);
        this.adjustDhModulus(message);
        this.adjustServerPublicKey(message);
        this.adjustSelectedSignatureAndHashAlgorithm(message);
        this.recognizeNamedGroup();
        if (((DHEServerKeyExchangeMessage)message).getKeyExchangeComputations() != null && ((DHEServerKeyExchangeMessage)message).getKeyExchangeComputations().getPrivateKey() != null) {
            this.adjustServerPrivateKey(message);
        }
    }

    protected void adjustDhGenerator(KeyExchangeMessage message) {
        this.tlsContext.setServerEphemeralDhGenerator(new BigInteger(1, (byte[])((DHEServerKeyExchangeMessage)message).getGenerator().getValue()));
        LOGGER.debug("Dh Generator: {}", (Object)this.tlsContext.getServerEphemeralDhGenerator());
    }

    protected void adjustDhModulus(KeyExchangeMessage message) {
        this.tlsContext.setServerEphemeralDhModulus(new BigInteger(1, (byte[])((DHEServerKeyExchangeMessage)message).getModulus().getValue()));
        LOGGER.debug("Dh Modulus: {}", (Object)this.tlsContext.getServerEphemeralDhModulus());
    }

    protected void adjustServerPublicKey(KeyExchangeMessage message) {
        this.tlsContext.setServerEphemeralDhPublicKey(new BigInteger(1, (byte[])((ServerKeyExchangeMessage)message).getPublicKey().getValue()));
        LOGGER.debug("Server PublicKey: {}", (Object)this.tlsContext.getServerEphemeralDhPublicKey());
    }

    protected void adjustServerPrivateKey(KeyExchangeMessage message) {
        this.tlsContext.setServerEphemeralDhPrivateKey((BigInteger)((DHEServerKeyExchangeMessage)message).getKeyExchangeComputations().getPrivateKey().getValue());
        LOGGER.debug("Server PrivateKey: {}", (Object)this.tlsContext.getServerEphemeralDhPrivateKey());
    }

    private void recognizeNamedGroup() {
        BigInteger serverDhGenerator = this.tlsContext.getServerEphemeralDhGenerator();
        BigInteger serverDhModulus = this.tlsContext.getServerEphemeralDhModulus();
        for (NamedGroup group : NamedGroup.getImplemented()) {
            FfdhGroupParameters ffdhGroup;
            if (!group.isDhGroup() || !serverDhGenerator.equals((ffdhGroup = (FfdhGroupParameters)group.getGroupParameters()).getGenerator()) || !serverDhModulus.equals(ffdhGroup.getModulus())) continue;
            this.tlsContext.setSelectedGroup(group);
            LOGGER.debug("Set recognized NamedGroup {} of Server Key Exchange message as selected in context", (Object)group);
            break;
        }
    }
}

