/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.ClientKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DHClientKeyExchangeHandler<KeyExchangeMessage extends DHClientKeyExchangeMessage>
extends ClientKeyExchangeHandler<KeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public DHClientKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(KeyExchangeMessage message) {
        this.adjustPremasterSecret(message);
        this.adjustMasterSecret(message);
        this.adjustClientPublicKey((DHClientKeyExchangeMessage)message);
        this.spawnNewSession();
    }

    private void adjustClientPublicKey(DHClientKeyExchangeMessage message) {
        if (((byte[])message.getPublicKey().getValue()).length == 0) {
            LOGGER.debug("Empty DH Key");
        } else {
            this.tlsContext.setClientEphemeralDhPublicKey(new BigInteger((byte[])message.getPublicKey().getValue()));
        }
    }
}

