/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ApplicationMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationMessageHandler
extends ProtocolMessageHandler<ApplicationMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ApplicationMessageHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(ApplicationMessage message) {
        this.tlsContext.setLastHandledApplicationMessageData((byte[])message.getData().getValue());
        if (LOGGER.isDebugEnabled()) {
            if (this.tlsContext.getTalkingConnectionEndType() == this.tlsContext.getChooser().getMyConnectionPeer()) {
                LOGGER.debug("Received Data: {}", (Object)this.tlsContext.getLastHandledApplicationMessageData());
            } else {
                LOGGER.debug("Send Data: {}", (Object)this.tlsContext.getLastHandledApplicationMessageData());
            }
        }
    }
}

