/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.impl;

import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerProcessingResult;
import de.rub.nds.tlsattacker.core.layer.ProtocolLayer;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.hints.LayerProcessingHint;
import de.rub.nds.tlsattacker.core.layer.stream.HintedLayerInputStream;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.udp.UdpDataPacket;
import de.rub.nds.tlsattacker.transport.udp.UdpTransportHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class UdpLayer
extends ProtocolLayer<Context, LayerProcessingHint, UdpDataPacket> {
    private final Context context;

    public UdpLayer(Context context) {
        super(ImplementedLayers.UDP);
        this.context = context;
    }

    @Override
    public LayerProcessingResult<UdpDataPacket> sendConfiguration() throws IOException {
        LayerConfiguration configuration = this.getLayerConfiguration();
        if (configuration != null) {
            for (UdpDataPacket udpDataPacket : this.getUnprocessedConfiguredContainers()) {
                this.prepareDataContainer(udpDataPacket, this.context);
                this.addProducedContainer(udpDataPacket);
                UdpTransportHandler handler = this.getTransportHandler();
                handler.sendData(udpDataPacket.getSerializer(this.context).serialize());
            }
        }
        return this.getLayerResult();
    }

    @Override
    public LayerProcessingResult<UdpDataPacket> sendData(LayerProcessingHint hint, byte[] data) throws IOException {
        UdpDataPacket udpDataPacket = this.getUnprocessedConfiguredContainers().isEmpty() ? new UdpDataPacket() : (UdpDataPacket)this.getUnprocessedConfiguredContainers().get(0);
        udpDataPacket.setConfigData(data);
        this.prepareDataContainer(udpDataPacket, this.context);
        this.addProducedContainer(udpDataPacket);
        UdpTransportHandler handler = this.getTransportHandler();
        handler.sendData(udpDataPacket.getSerializer(this.context).serialize());
        return this.getLayerResult();
    }

    @Override
    public void receiveMoreDataForHint(LayerProcessingHint hint) throws IOException {
        byte[] receivedPacket = this.getTransportHandler().fetchData();
        UdpDataPacket udpDataPacket = new UdpDataPacket();
        udpDataPacket.getParser(this.context, new ByteArrayInputStream(receivedPacket)).parse(udpDataPacket);
        udpDataPacket.getPreparator(this.context).prepareAfterParse();
        udpDataPacket.getHandler(this.context).adjustContext(udpDataPacket);
        this.addProducedContainer(udpDataPacket);
        if (this.currentInputStream == null) {
            this.currentInputStream = new HintedLayerInputStream(null, this);
            this.currentInputStream.extendStream(receivedPacket);
        } else {
            this.currentInputStream.extendStream(receivedPacket);
        }
    }

    @Override
    public LayerProcessingResult<UdpDataPacket> receiveData() {
        return new LayerProcessingResult<UdpDataPacket>(null, this.getLayerType(), true);
    }

    private UdpTransportHandler getTransportHandler() {
        if (this.context.getTransportHandler() == null) {
            throw new RuntimeException("TransportHandler is not set in context!");
        }
        if (!(this.context.getTransportHandler() instanceof UdpTransportHandler)) {
            throw new RuntimeException("Trying to set UDP layer with non UDP TransportHandler");
        }
        return (UdpTransportHandler)this.context.getTransportHandler();
    }
}

