/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.impl;

import de.rub.nds.protocol.exception.EndOfStreamException;
import de.rub.nds.protocol.exception.TimeoutException;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.layer.AcknowledgingProtocolLayer;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerProcessingResult;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.hints.LayerProcessingHint;
import de.rub.nds.tlsattacker.core.layer.hints.QuicFrameLayerHint;
import de.rub.nds.tlsattacker.core.layer.hints.QuicPacketLayerHint;
import de.rub.nds.tlsattacker.core.layer.hints.RecordLayerHint;
import de.rub.nds.tlsattacker.core.layer.stream.HintedInputStream;
import de.rub.nds.tlsattacker.core.layer.stream.HintedLayerInputStream;
import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.frame.AckFrame;
import de.rub.nds.tlsattacker.core.quic.frame.ConnectionCloseFrame;
import de.rub.nds.tlsattacker.core.quic.frame.CryptoFrame;
import de.rub.nds.tlsattacker.core.quic.frame.HandshakeDoneFrame;
import de.rub.nds.tlsattacker.core.quic.frame.NewConnectionIdFrame;
import de.rub.nds.tlsattacker.core.quic.frame.NewTokenFrame;
import de.rub.nds.tlsattacker.core.quic.frame.PaddingFrame;
import de.rub.nds.tlsattacker.core.quic.frame.PathChallengeFrame;
import de.rub.nds.tlsattacker.core.quic.frame.PathResponseFrame;
import de.rub.nds.tlsattacker.core.quic.frame.PingFrame;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.frame.StreamFrame;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.PortUnreachableException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QuicFrameLayer
extends AcknowledgingProtocolLayer<Context, QuicFrameLayerHint, QuicFrame> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Context context;
    private final QuicContext quicContext;
    private final int MAX_FRAME_SIZE;
    private final int DEFAULT_STREAM_ID = 2;
    private final int MIN_FRAME_SIZE = 32;
    private long initialPhaseExpectedCryptoFrameOffset = 0L;
    private long handshakePhaseExpectedCryptoFrameOffset = 0L;
    private long applicationPhaseExpectedCryptoFrameOffset = 0L;
    private List<CryptoFrame> cryptoFrameBuffer = new ArrayList<CryptoFrame>();
    private boolean hasExperiencedTimeout = false;

    public QuicFrameLayer(Context context) {
        super(ImplementedLayers.QUICFRAME);
        this.context = context;
        this.quicContext = context.getQuicContext();
        this.MAX_FRAME_SIZE = context.getConfig().getQuicMaximumFrameSize();
    }

    @Override
    public LayerProcessingResult<QuicFrame> sendConfiguration() throws IOException {
        LayerConfiguration configuration = this.getLayerConfiguration();
        if (configuration != null && configuration.getContainerList() != null) {
            for (QuicFrame frame : configuration.getContainerList()) {
                byte[] bytes = this.writeFrame(frame);
                QuicPacketLayerHint hint = this.getHintForFrame();
                this.addProducedContainer(frame);
                this.getLowerLayer().sendData(hint, bytes);
            }
        }
        return this.getLayerResult();
    }

    @Override
    public LayerProcessingResult<QuicFrame> sendData(LayerProcessingHint hint, byte[] data) throws IOException {
        block13: {
            block12: {
                boolean hintedFirstMessage;
                ProtocolMessageType hintedType;
                if (hint instanceof QuicFrameLayerHint) {
                    hintedType = ((QuicFrameLayerHint)hint).getMessageType();
                    hintedFirstMessage = ((QuicFrameLayerHint)hint).isFirstMessage();
                } else {
                    hintedType = ProtocolMessageType.UNKNOWN;
                    hintedFirstMessage = true;
                }
                if (hint == null || hintedType == null) break block12;
                SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
                switch (hintedType) {
                    case HANDSHAKE: {
                        QuicPacketLayerHint packetLayerHint = hintedFirstMessage ? new QuicPacketLayerHint(QuicPacketType.INITIAL_PACKET) : new QuicPacketLayerHint(QuicPacketType.HANDSHAKE_PACKET);
                        List<Object> givenFrames = this.getUnprocessedConfiguredContainers();
                        if (this.getLayerConfiguration().getContainerList() != null && givenFrames.size() > 0) {
                            givenFrames = givenFrames.stream().filter(frame -> QuicFrameType.getFrameType((Byte)frame.getFrameType().getValue()) == QuicFrameType.CRYPTO_FRAME).collect(Collectors.toList());
                            int offset = 0;
                            for (QuicFrame quicFrame : givenFrames) {
                                int toCopy = ((CryptoFrame)quicFrame).getMaxFrameLengthConfig() != 0 ? ((CryptoFrame)quicFrame).getMaxFrameLengthConfig() : this.MAX_FRAME_SIZE;
                                byte[] payload = Arrays.copyOfRange(data, offset, offset + toCopy);
                                ((CryptoFrame)quicFrame).setCryptoDataConfig(payload);
                                ((CryptoFrame)quicFrame).setOffsetConfig(offset);
                                ((CryptoFrame)quicFrame).setLengthConfig(payload.length);
                                stream = new SilentByteArrayOutputStream();
                                stream.writeBytes(this.writeFrame(quicFrame));
                                this.addProducedContainer(quicFrame);
                                this.getLowerLayer().sendData(packetLayerHint, stream.toByteArray());
                                if ((offset += toCopy) < data.length) continue;
                                break;
                            }
                            while (offset < data.length) {
                                byte[] payload = Arrays.copyOfRange(data, offset, Math.min(offset + this.MAX_FRAME_SIZE, data.length));
                                CryptoFrame cryptoFrame = new CryptoFrame(payload, offset, payload.length);
                                stream = new SilentByteArrayOutputStream();
                                stream.writeBytes(this.writeFrame(cryptoFrame));
                                this.addProducedContainer(cryptoFrame);
                                this.getLowerLayer().sendData(packetLayerHint, stream.toByteArray());
                                offset += this.MAX_FRAME_SIZE;
                            }
                        } else {
                            for (int offset = 0; offset < data.length; offset += this.MAX_FRAME_SIZE) {
                                byte[] payload = Arrays.copyOfRange(data, offset, Math.min(offset + this.MAX_FRAME_SIZE, data.length));
                                CryptoFrame cryptoFrame = new CryptoFrame(payload, offset, payload.length);
                                stream = new SilentByteArrayOutputStream();
                                stream.writeBytes(this.writeFrame(cryptoFrame));
                                this.addProducedContainer(cryptoFrame);
                                this.getLowerLayer().sendData(packetLayerHint, stream.toByteArray());
                            }
                        }
                        break block13;
                    }
                    case APPLICATION_DATA: {
                        QuicPacketLayerHint packetLayerHint = this.quicContext.isApplicationSecretsInitialized() ? new QuicPacketLayerHint(QuicPacketType.ONE_RTT_PACKET) : new QuicPacketLayerHint(QuicPacketType.ZERO_RTT_PACKET);
                        StreamFrame frame4 = new StreamFrame(data, 2);
                        stream.writeBytes(this.writeFrame(frame4));
                        this.addProducedContainer(frame4);
                        if (data.length < 32) {
                            PaddingFrame paddingFrame = new PaddingFrame(32 - data.length);
                            stream.writeBytes(this.writeFrame(paddingFrame));
                            this.addProducedContainer(paddingFrame);
                        }
                        this.getLowerLayer().sendData(packetLayerHint, stream.toByteArray());
                        break;
                    }
                    default: {
                        LOGGER.debug("Unsupported message type: {}", (Object)hintedType);
                    }
                }
                break block13;
            }
            throw new UnsupportedOperationException("No QuicFrameLayerHint passed - Not supported yet.");
        }
        return this.getLayerResult();
    }

    @Override
    public LayerProcessingResult<QuicFrame> receiveData() {
        try {
            do {
                HintedInputStream dataStream = this.getLowerLayer().getDataStream();
                this.readFrames(dataStream);
            } while (this.shouldContinueProcessing());
        }
        catch (TimeoutException | SocketTimeoutException ex) {
            LOGGER.debug("Received a timeout");
            LOGGER.trace((Object)ex);
            this.hasExperiencedTimeout = true;
        }
        catch (PortUnreachableException ex) {
            LOGGER.debug("Desitination port unreachable");
            LOGGER.trace((Object)ex);
            this.hasExperiencedTimeout = true;
        }
        catch (EndOfStreamException ex) {
            LOGGER.debug("Reached end of stream, cannot parse more messages");
            LOGGER.trace((Object)ex);
            this.hasExperiencedTimeout = true;
        }
        catch (IOException ex) {
            LOGGER.warn("The lower layer did not produce a data stream: ", (Throwable)ex);
        }
        return this.getLayerResult();
    }

    @Override
    public void receiveMoreDataForHint(LayerProcessingHint hint) throws IOException {
        try {
            HintedInputStream dataStream = this.getLowerLayer().getDataStream();
            this.readFrames(dataStream);
        }
        catch (PortUnreachableException ex) {
            LOGGER.debug("Received a ICMP Port Unreachable");
            LOGGER.trace((Object)ex);
            this.hasExperiencedTimeout = true;
        }
        catch (TimeoutException | SocketTimeoutException ex) {
            LOGGER.debug("Received a timeout");
            LOGGER.trace((Object)ex);
            this.hasExperiencedTimeout = true;
        }
        catch (EndOfStreamException ex) {
            LOGGER.debug("Reached end of stream, cannot parse more messages");
            LOGGER.trace((Object)ex);
            this.hasExperiencedTimeout = true;
        }
    }

    private void readFrames(InputStream dataStream) throws IOException {
        PushbackInputStream inputStream = new PushbackInputStream(dataStream);
        RecordLayerHint recordLayerHint = null;
        boolean isAckEliciting = false;
        if (inputStream.available() == 0) {
            throw new EndOfStreamException();
        }
        block15: while (inputStream.available() > 0) {
            int firstByte = inputStream.read();
            QuicFrameType frameType = QuicFrameType.getFrameType((byte)firstByte);
            switch (frameType) {
                case ACK_FRAME: {
                    this.readDataContainer(new AckFrame(false), this.context, inputStream);
                    continue block15;
                }
                case ACK_FRAME_WITH_ECN: {
                    this.readDataContainer(new AckFrame(true), this.context, inputStream);
                    continue block15;
                }
                case CONNECTION_CLOSE_QUIC_FRAME: {
                    this.readDataContainer(new ConnectionCloseFrame(true), this.context, inputStream);
                    continue block15;
                }
                case CONNECTION_CLOSE_APPLICATION_FRAME: {
                    this.readDataContainer(new ConnectionCloseFrame(false), this.context, inputStream);
                    continue block15;
                }
                case CRYPTO_FRAME: {
                    recordLayerHint = new RecordLayerHint(ProtocolMessageType.HANDSHAKE);
                    CryptoFrame frame2 = new CryptoFrame();
                    this.readDataContainer(frame2, this.context, inputStream);
                    this.cryptoFrameBuffer.add(frame2);
                    isAckEliciting = true;
                    continue block15;
                }
                case HANDSHAKE_DONE_FRAME: {
                    this.readDataContainer(new HandshakeDoneFrame(), this.context, inputStream);
                    isAckEliciting = true;
                    continue block15;
                }
                case NEW_CONNECTION_ID_FRAME: {
                    this.readDataContainer(new NewConnectionIdFrame(), this.context, inputStream);
                    isAckEliciting = true;
                    continue block15;
                }
                case NEW_TOKEN_FRAME: {
                    this.readDataContainer(new NewTokenFrame(), this.context, inputStream);
                    isAckEliciting = true;
                    continue block15;
                }
                case PADDING_FRAME: {
                    this.readDataContainer(new PaddingFrame(), this.context, inputStream);
                    continue block15;
                }
                case PATH_CHALLENGE_FRAME: {
                    this.readDataContainer(new PathChallengeFrame(), this.context, inputStream);
                    isAckEliciting = true;
                    continue block15;
                }
                case PATH_RESPONSE_FRAME: {
                    this.readDataContainer(new PathResponseFrame(), this.context, inputStream);
                    isAckEliciting = true;
                    continue block15;
                }
                case PING_FRAME: {
                    this.readDataContainer(new PingFrame(), this.context, inputStream);
                    isAckEliciting = true;
                    continue block15;
                }
                case STREAM_FRAME: 
                case STREAM_FRAME_OFF_LEN_FIN: 
                case STREAM_FRAME_OFF_LEN: 
                case STREAM_FRAME_LEN_FIN: 
                case STREAM_FRAME_OFF_FIN: 
                case STREAM_FRAME_FIN: 
                case STREAM_FRAME_LEN: 
                case STREAM_FRAME_OFF: {
                    this.readDataContainer(new StreamFrame(frameType), this.context, inputStream);
                    isAckEliciting = true;
                    continue block15;
                }
            }
            LOGGER.error("Undefined QUIC frame type: {}", (Object)firstByte);
        }
        SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();
        if (!this.cryptoFrameBuffer.isEmpty()) {
            this.cryptoFrameBuffer.sort(Comparator.comparingLong(frame -> (Long)frame.getOffset().getValue()));
            this.cryptoFrameBuffer = this.cryptoFrameBuffer.stream().distinct().collect(Collectors.toList());
            if (this.isCryptoBufferConsecutive()) {
                for (CryptoFrame frame2 : this.cryptoFrameBuffer) {
                    outputStream.write((byte[])frame2.getCryptoData().getValue());
                }
                CryptoFrame lastFrame = this.cryptoFrameBuffer.get(this.cryptoFrameBuffer.size() - 1);
                long nextExpectedCryptoOffset = (Long)lastFrame.getOffset().getValue() + (Long)lastFrame.getLength().getValue();
                if (!this.quicContext.isHandshakeSecretsInitialized()) {
                    this.initialPhaseExpectedCryptoFrameOffset = nextExpectedCryptoOffset;
                } else if (!this.quicContext.isApplicationSecretsInitialized()) {
                    this.handshakePhaseExpectedCryptoFrameOffset = nextExpectedCryptoOffset;
                } else {
                    this.applicationPhaseExpectedCryptoFrameOffset = nextExpectedCryptoOffset;
                }
                this.cryptoFrameBuffer.clear();
            }
        }
        if (isAckEliciting) {
            this.sendAck(null);
        } else if (!this.quicContext.getReceivedPackets().isEmpty()) {
            this.quicContext.getReceivedPackets().removeLast();
        }
        if (this.currentInputStream == null) {
            this.currentInputStream = new HintedLayerInputStream(recordLayerHint, this);
            this.currentInputStream.extendStream(outputStream.toByteArray());
        } else {
            this.currentInputStream.setHint(recordLayerHint);
            this.currentInputStream.extendStream(outputStream.toByteArray());
        }
        outputStream.flush();
    }

    private boolean isCryptoBufferConsecutive() {
        long lastSeenCryptoOffset = !this.quicContext.isHandshakeSecretsInitialized() ? this.initialPhaseExpectedCryptoFrameOffset : (!this.quicContext.isApplicationSecretsInitialized() ? this.handshakePhaseExpectedCryptoFrameOffset : this.applicationPhaseExpectedCryptoFrameOffset);
        if ((Long)this.cryptoFrameBuffer.get(0).getOffset().getValue() != lastSeenCryptoOffset) {
            LOGGER.warn("Missing CryptoFrames in buffer: {}, lastSeenCryptoOffset={}", (Object)this.cryptoBufferToString(), (Object)lastSeenCryptoOffset);
            return false;
        }
        for (int i = 1; i < this.cryptoFrameBuffer.size(); ++i) {
            if ((Long)this.cryptoFrameBuffer.get(i).getOffset().getValue() == (Long)this.cryptoFrameBuffer.get(i - 1).getOffset().getValue() + (Long)this.cryptoFrameBuffer.get(i - 1).getLength().getValue()) continue;
            LOGGER.warn("Missing CryptoFrames in buffer: {}, lastSeenCryptoOffset={}", (Object)this.cryptoBufferToString(), (Object)lastSeenCryptoOffset);
            return false;
        }
        return true;
    }

    private String cryptoBufferToString() {
        return this.cryptoFrameBuffer.stream().map(cryptoFrame -> "o: " + String.valueOf(cryptoFrame.getOffset().getValue()) + ", l: " + String.valueOf(cryptoFrame.getLength().getValue())).collect(Collectors.joining(" | "));
    }

    private byte[] writeFrame(QuicFrame frame) {
        frame.getPreparator(this.context).prepare();
        return frame.getSerializer(this.context).serialize();
    }

    private QuicPacketLayerHint getHintForFrame() {
        if (this.quicContext.isInitialSecretsInitialized() && !this.quicContext.isHandshakeSecretsInitialized()) {
            return new QuicPacketLayerHint(QuicPacketType.INITIAL_PACKET);
        }
        if (this.quicContext.isHandshakeSecretsInitialized() && !this.quicContext.isApplicationSecretsInitialized()) {
            return new QuicPacketLayerHint(QuicPacketType.HANDSHAKE_PACKET);
        }
        if (this.quicContext.isApplicationSecretsInitialized()) {
            return new QuicPacketLayerHint(QuicPacketType.ONE_RTT_PACKET);
        }
        return null;
    }

    @Override
    public void sendAck(byte[] data) {
        AckFrame frame = new AckFrame(false);
        if (this.quicContext.getReceivedPackets().getLast() == QuicPacketType.INITIAL_PACKET) {
            frame.setLargestAcknowledgedConfig(this.quicContext.getReceivedInitialPacketNumbers().getLast().intValue());
            LOGGER.debug("Send Ack for Initial Packet #{}", (Object)frame.getLargestAcknowledgedConfig());
        } else if (this.quicContext.getReceivedPackets().getLast() == QuicPacketType.HANDSHAKE_PACKET) {
            frame.setLargestAcknowledgedConfig(this.quicContext.getReceivedHandshakePacketNumbers().getLast().intValue());
            LOGGER.debug("Send Ack for Handshake Packet #{}", (Object)frame.getLargestAcknowledgedConfig());
        } else if (this.quicContext.getReceivedPackets().getLast() == QuicPacketType.ONE_RTT_PACKET) {
            frame.setLargestAcknowledgedConfig(this.quicContext.getReceivedOneRTTPacketNumbers().getLast().intValue());
            LOGGER.debug("Send Ack for 1RTT Packet #{}", (Object)frame.getLargestAcknowledgedConfig());
        }
        frame.setAckDelayConfig(1L);
        frame.setAckRangeCountConfig(0L);
        frame.setFirstACKRangeConfig(0L);
        ((AcknowledgingProtocolLayer)this.getLowerLayer()).sendAck(this.writeFrame(frame));
    }

    public void clearCryptoFrameBuffer() {
        this.cryptoFrameBuffer.clear();
        this.initialPhaseExpectedCryptoFrameOffset = 0L;
        this.handshakePhaseExpectedCryptoFrameOffset = 0L;
        this.applicationPhaseExpectedCryptoFrameOffset = 0L;
    }

    public boolean hasExperiencedTimeout() {
        return this.hasExperiencedTimeout;
    }
}

