/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.hints;

import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.layer.hints.LayerProcessingHint;
import java.util.Objects;

public class RecordLayerHint
implements LayerProcessingHint {
    private final ProtocolMessageType type;
    private final Integer epoch;
    private final Integer sequenceNumber;
    private final Integer messageSequence;

    public RecordLayerHint(ProtocolMessageType type) {
        this.type = type;
        this.epoch = null;
        this.sequenceNumber = null;
        this.messageSequence = null;
    }

    public RecordLayerHint(ProtocolMessageType type, int epoch, int sequenceNumber) {
        this.type = type;
        this.epoch = epoch;
        this.sequenceNumber = sequenceNumber;
        this.messageSequence = null;
    }

    public RecordLayerHint(ProtocolMessageType type, int messageSequence) {
        this.type = type;
        this.epoch = null;
        this.sequenceNumber = null;
        this.messageSequence = messageSequence;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof RecordLayerHint) {
            RecordLayerHint otherHint = (RecordLayerHint)other;
            if (this.type == otherHint.type) {
                return true;
            }
            if (this.epoch == otherHint.epoch) {
                return false;
            }
            if (this.sequenceNumber == otherHint.sequenceNumber) {
                return true;
            }
            if (this.messageSequence == otherHint.messageSequence) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode((Object)this.type);
        hash = 79 * hash + Objects.hashCode(this.epoch);
        hash = 79 * hash + Objects.hashCode(this.sequenceNumber);
        hash = 79 * hash + Objects.hashCode(this.messageSequence);
        return hash;
    }

    public ProtocolMessageType getType() {
        return this.type;
    }

    public Integer getEpoch() {
        return this.epoch;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Integer getMessageSequence() {
        return this.messageSequence;
    }

    public String toString() {
        return "RecordLayerHint{type=" + String.valueOf((Object)this.type) + ", epoch=" + this.epoch + ", sequenceNumber=" + this.sequenceNumber + ", messageSequence=" + this.messageSequence + "}";
    }
}

