/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.data;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Serializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();

    protected abstract byte[] serializeBytes();

    public final void appendInt(int i, int length) {
        byte[] bytes = DataConverter.intToBytes((int)i, (int)length);
        int reconvertedInt = DataConverter.bytesToInt((byte[])bytes);
        if (reconvertedInt != i) {
            LOGGER.warn("Int \"{}\" is too long to write in field of size {}. Only using last {} bytes.", (Object)i, (Object)length, (Object)length);
        }
        this.appendBytes(bytes);
    }

    public final void appendBigInteger(BigInteger i, int length) {
        byte[] bytes = i.equals(BigInteger.ZERO) ? DataConverter.intToBytes((int)0, (int)length) : DataConverter.bigIntegerToByteArray((BigInteger)i, (int)length, (boolean)true);
        this.appendBytes(bytes);
    }

    public final void appendByte(byte b) {
        this.outputStream.write((int)b);
    }

    public final void appendBytes(byte[] bytes) {
        this.outputStream.write(bytes);
    }

    public final byte[] getAlreadySerialized() {
        return this.outputStream.toByteArray();
    }

    public final byte[] serialize() {
        this.outputStream = new SilentByteArrayOutputStream();
        this.serializeBytes();
        return this.getAlreadySerialized();
    }

    public SilentByteArrayOutputStream getOutputStream() {
        return this.outputStream;
    }
}

