/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.http;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.string.ModifiableString;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.http.HttpMessage;
import de.rub.nds.tlsattacker.core.http.HttpResponseHandler;
import de.rub.nds.tlsattacker.core.http.HttpResponseParser;
import de.rub.nds.tlsattacker.core.http.HttpResponsePreparator;
import de.rub.nds.tlsattacker.core.http.HttpResponseSerializer;
import de.rub.nds.tlsattacker.core.http.header.ContentLengthHeader;
import de.rub.nds.tlsattacker.core.http.header.DateHeader;
import de.rub.nds.tlsattacker.core.http.header.ExpiresHeader;
import de.rub.nds.tlsattacker.core.http.header.GenericHttpHeader;
import de.rub.nds.tlsattacker.core.http.header.HostHeader;
import de.rub.nds.tlsattacker.core.http.header.HttpHeader;
import de.rub.nds.tlsattacker.core.http.header.LocationHeader;
import de.rub.nds.tlsattacker.core.http.header.TokenBindingHeader;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement
public class HttpResponseMessage
extends HttpMessage {
    private ModifiableString responseProtocol;
    private ModifiableString responseStatusCode;
    private ModifiableString responseContent;
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(type=GenericHttpHeader.class, name="HttpHeader"), @XmlElement(type=ContentLengthHeader.class, name="ContentLengthHeader"), @XmlElement(type=DateHeader.class, name="DateHeader"), @XmlElement(type=ExpiresHeader.class, name="ExpiresHeader"), @XmlElement(type=LocationHeader.class, name="LocationHeader"), @XmlElement(type=HostHeader.class, name="HostHeader"), @XmlElement(type=TokenBindingHeader.class, name="TokenBindingHeader")})
    @HoldsModifiableVariable
    private List<HttpHeader> header = new LinkedList<HttpHeader>();
    @HoldsModifiableVariable
    private List<HttpHeader> trailer;

    public HttpResponseMessage() {
        this.trailer = new LinkedList<HttpHeader>();
    }

    public HttpResponseMessage(Config config) {
        this.header.add(new GenericHttpHeader("Content-Type", "text/html; charset=UTF-8"));
        this.header.add(new LocationHeader());
        this.header.add(new ContentLengthHeader());
        this.header.add(new DateHeader());
        this.header.add(new ExpiresHeader());
        this.header.add(new GenericHttpHeader("Cache-Control", "private, max-age=0"));
        this.header.add(new GenericHttpHeader("Server", "GSE"));
        this.trailer = new LinkedList<HttpHeader>();
    }

    public ModifiableString getResponseProtocol() {
        return this.responseProtocol;
    }

    public void setResponseProtocol(ModifiableString responseProtocol) {
        this.responseProtocol = responseProtocol;
    }

    public void setResponseProtocol(String responseProtocol) {
        this.responseProtocol = ModifiableVariableFactory.safelySetValue((ModifiableString)this.responseProtocol, (String)responseProtocol);
    }

    public ModifiableString getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public void setResponseStatusCode(ModifiableString responseStatusCode) {
        this.responseStatusCode = responseStatusCode;
    }

    public void setResponseStatusCode(String responseStatusCode) {
        this.responseStatusCode = ModifiableVariableFactory.safelySetValue((ModifiableString)this.responseStatusCode, (String)responseStatusCode);
    }

    public ModifiableString getResponseContent() {
        return this.responseContent;
    }

    public void setResponseContent(ModifiableString responseContent) {
        this.responseContent = responseContent;
    }

    public void setResponseContent(String responseContent) {
        this.responseContent = ModifiableVariableFactory.safelySetValue((ModifiableString)this.responseContent, (String)responseContent);
    }

    public List<HttpHeader> getHeader() {
        return this.header;
    }

    public void setHeader(List<HttpHeader> header) {
        this.header = header;
    }

    public List<HttpHeader> getTrailer() {
        return this.trailer;
    }

    public void setTrailer(List<HttpHeader> trailer) {
        this.trailer = trailer;
    }

    @Override
    public String toCompactString() {
        return "HttpResponseMessage";
    }

    @Override
    public String toShortString() {
        return "HTTP_RES";
    }

    @Override
    public HttpResponseHandler getHandler(Context httpContext) {
        return new HttpResponseHandler();
    }

    @Override
    public HttpResponseParser getParser(Context context, InputStream stream) {
        return new HttpResponseParser(stream, context.getConfig().getDefaultMaxHttpLength());
    }

    @Override
    public HttpResponsePreparator getPreparator(Context context) {
        return new HttpResponsePreparator(context.getHttpContext(), this);
    }

    @Override
    public HttpResponseSerializer getSerializer(Context context) {
        return new HttpResponseSerializer(this);
    }
}

