/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.http;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.string.ModifiableString;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.http.HttpMessage;
import de.rub.nds.tlsattacker.core.http.HttpRequestHandler;
import de.rub.nds.tlsattacker.core.http.HttpRequestParser;
import de.rub.nds.tlsattacker.core.http.HttpRequestPreparator;
import de.rub.nds.tlsattacker.core.http.HttpRequestSerializer;
import de.rub.nds.tlsattacker.core.http.header.ContentLengthHeader;
import de.rub.nds.tlsattacker.core.http.header.CookieHeader;
import de.rub.nds.tlsattacker.core.http.header.DateHeader;
import de.rub.nds.tlsattacker.core.http.header.ExpiresHeader;
import de.rub.nds.tlsattacker.core.http.header.GenericHttpHeader;
import de.rub.nds.tlsattacker.core.http.header.HostHeader;
import de.rub.nds.tlsattacker.core.http.header.HttpHeader;
import de.rub.nds.tlsattacker.core.http.header.LocationHeader;
import de.rub.nds.tlsattacker.core.http.header.TokenBindingHeader;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement
public class HttpRequestMessage
extends HttpMessage {
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(type=GenericHttpHeader.class, name="HttpHeader"), @XmlElement(type=ContentLengthHeader.class, name="ContentLengthHeader"), @XmlElement(type=DateHeader.class, name="DateHeader"), @XmlElement(type=ExpiresHeader.class, name="ExpiresHeader"), @XmlElement(type=LocationHeader.class, name="LocationHeader"), @XmlElement(type=HostHeader.class, name="HostHeader"), @XmlElement(type=TokenBindingHeader.class, name="TokenBindingHeader"), @XmlElement(type=TokenBindingHeader.class, name="CookieHeader")})
    @HoldsModifiableVariable
    private List<HttpHeader> header = new LinkedList<HttpHeader>();
    private ModifiableString requestType;
    private ModifiableString requestPath;
    private ModifiableString requestProtocol;

    public HttpRequestMessage() {
    }

    public HttpRequestMessage(Config config) {
        this.header.add(new HostHeader());
        this.header.add(new GenericHttpHeader("Connection", "keep-alive"));
        this.header.add(new GenericHttpHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8"));
        this.header.add(new GenericHttpHeader("Accept-Encoding", "identity"));
        this.header.add(new GenericHttpHeader("Accept-Language", "de-DE,de;q=0.8,en-US;q=0.6,en;q=0.4"));
        if (config.isAddTokenBindingExtension().booleanValue()) {
            this.header.add(new TokenBindingHeader());
        }
        if (config.isAddHttpCookie().booleanValue()) {
            this.header.add(new CookieHeader());
        }
        this.header.add(new GenericHttpHeader("Upgrade-Insecure-Requests", "1"));
        this.header.add(new GenericHttpHeader("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Ubuntu Chromium/59.0.3071.109 Chrome/59.0.3071.109 Safari/537.36"));
    }

    public List<HttpHeader> getHeader() {
        return this.header;
    }

    public void setHeader(List<HttpHeader> header) {
        this.header = header;
    }

    public ModifiableString getRequestType() {
        return this.requestType;
    }

    public void setRequestType(ModifiableString requestType) {
        this.requestType = requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = ModifiableVariableFactory.safelySetValue((ModifiableString)this.requestType, (String)requestType);
    }

    public ModifiableString getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(ModifiableString requestPath) {
        this.requestPath = requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = ModifiableVariableFactory.safelySetValue((ModifiableString)this.requestPath, (String)requestPath);
    }

    public ModifiableString getRequestProtocol() {
        return this.requestProtocol;
    }

    public void setRequestProtocol(ModifiableString requestProtocol) {
        this.requestProtocol = requestProtocol;
    }

    public void setRequestProtocol(String requestProtocol) {
        this.requestProtocol = ModifiableVariableFactory.safelySetValue((ModifiableString)this.requestProtocol, (String)requestProtocol);
    }

    @Override
    public String toCompactString() {
        return "HttpRequestMessage";
    }

    @Override
    public String toShortString() {
        return "HTTP_REQ";
    }

    @Override
    public HttpRequestHandler getHandler(Context context) {
        return new HttpRequestHandler(context.getHttpContext());
    }

    @Override
    public HttpRequestParser getParser(Context context, InputStream stream) {
        return new HttpRequestParser(stream);
    }

    @Override
    public HttpRequestPreparator getPreparator(Context context) {
        return new HttpRequestPreparator(context.getHttpContext(), this);
    }

    @Override
    public HttpRequestSerializer getSerializer(Context context) {
        return new HttpRequestSerializer(this);
    }
}

