/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.cipher;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.cipher.BaseCipher;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import org.bouncycastle.util.Arrays;

public class GOST28147Cipher
extends BaseCipher {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final byte[] C = new byte[]{105, 0, 114, 34, 100, -55, 4, 35, -115, 58, -37, -106, 70, -23, 42, -60, 24, -2, -84, -108, 0, -19, 7, 18, -64, -122, -36, -62, -17, 76, -87, 43};
    private static final CipherAlgorithm algorithm = CipherAlgorithm.GOST_28147_CNT_IMIT;
    private int keyCount;
    private byte[] key;
    private byte[] state;
    private byte[] keyStream;
    private final Cipher cipher;
    private final GOST28147ParameterSpec spec;

    public static byte[] getC() {
        return Arrays.copyOf((byte[])C, (int)C.length);
    }

    public GOST28147Cipher(GOST28147ParameterSpec spec, byte[] key, byte[] iv) {
        this.spec = spec;
        this.key = key;
        this.state = iv;
        try {
            this.cipher = Cipher.getInstance(algorithm.getJavaName());
            this.initCipher(1);
        }
        catch (GeneralSecurityException e) {
            throw new UnsupportedOperationException("Could not initialize cipher " + String.valueOf((Object)algorithm) + "!");
        }
    }

    private void initCipher(int mode) throws GeneralSecurityException {
        this.cipher.init(mode, (Key)new SecretKeySpec(this.key, algorithm.getJavaName()), (AlgorithmParameterSpec)this.spec);
    }

    private byte getKeyByte() throws GeneralSecurityException {
        if (this.keyCount % 8 == 0) {
            if (this.keyCount == 1024) {
                this.keyCount = 0;
                this.initCipher(2);
                this.key = this.cipher.doFinal(C);
                this.initCipher(1);
            }
            if (this.keyCount == 0) {
                this.state = this.cipher.doFinal(this.state);
            }
            this.increment();
            this.keyStream = this.cipher.doFinal(this.state);
        }
        return this.keyStream[this.keyCount++ % 8];
    }

    private void increment() {
        ByteBuffer wrappedIv = ByteBuffer.wrap(this.state);
        wrappedIv.order(ByteOrder.LITTLE_ENDIAN);
        int y = wrappedIv.getInt();
        int z = wrappedIv.getInt();
        int tmpZ = z + 0x1010104;
        z = tmpZ >= 0 && z < 0 ? tmpZ + 1 : tmpZ;
        wrappedIv.putInt(0, y += 0x1010101);
        wrappedIv.putInt(4, z);
    }

    @Override
    public byte[] encrypt(byte[] someBytes) throws CryptoException {
        try {
            byte[] encrypted = new byte[someBytes.length];
            for (int i = 0; i < someBytes.length; ++i) {
                encrypted[i] = (byte)(this.getKeyByte() ^ someBytes[i]);
            }
            return encrypted;
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException("Could not generate next key byte!", (Throwable)e);
        }
    }

    @Override
    public byte[] encrypt(byte[] iv, int tagLength, byte[] additionAuthenticatedData, byte[] someBytes) {
        throw new UnsupportedOperationException("Can only be used as a stream cipher!");
    }

    @Override
    public byte[] encrypt(byte[] iv, byte[] someBytes) {
        throw new UnsupportedOperationException("Can only be used as a stream cipher!");
    }

    @Override
    public byte[] encrypt(byte[] iv, int tagLength, byte[] someBytes) {
        throw new UnsupportedOperationException("Can only be used as a stream cipher!");
    }

    @Override
    public byte[] decrypt(byte[] someBytes) throws CryptoException {
        return this.encrypt(someBytes);
    }

    @Override
    public byte[] decrypt(byte[] iv, byte[] someBytes) {
        return this.encrypt(iv, someBytes);
    }

    @Override
    public byte[] decrypt(byte[] iv, int tagLength, byte[] someBytes) {
        return this.encrypt(iv, tagLength, someBytes);
    }

    @Override
    public byte[] decrypt(byte[] iv, int tagLength, byte[] additionAuthenticatedData, byte[] someBytes) {
        return this.encrypt(iv, tagLength, additionAuthenticatedData, someBytes);
    }

    @Override
    public int getBlocksize() {
        throw new UnsupportedOperationException("Can only be used as a stream cipher!");
    }

    @Override
    public byte[] getIv() {
        throw new UnsupportedOperationException("Can only be used as a stream cipher!");
    }

    @Override
    public void setIv(byte[] iv) {
        throw new UnsupportedOperationException("Can only be used as a stream cipher!");
    }

    @Override
    public byte[] getDtls13Mask(byte[] key, byte[] ciphertext) throws CryptoException {
        LOGGER.warn("Selected cipher does not support DTLS 1.3 masking. Returning empty mask!");
        return new byte[0];
    }
}

