/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants.hpke;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public enum HpkeMode {
    MODE_BASE(new byte[]{0}),
    MODE_PSK(new byte[]{1}),
    MODE_AUTH(new byte[]{2}),
    MODE_AUTH_PSK(new byte[]{3});

    private static final Map<BigInteger, HpkeMode> MAP;
    private final byte[] byteValue;

    private HpkeMode(byte[] byteValue) {
        this.byteValue = byteValue;
    }

    public byte[] getByteValue() {
        return this.byteValue;
    }

    public static HpkeMode getEnumByByte(byte[] versionBytes) {
        BigInteger hashMapKey = new BigInteger(versionBytes);
        return MAP.get(hashMapKey);
    }

    static {
        MAP = new HashMap<BigInteger, HpkeMode>();
        for (HpkeMode version : HpkeMode.values()) {
            byte[] versionBytes = version.getByteValue();
            if (versionBytes == null) continue;
            BigInteger hashMapKey = new BigInteger(versionBytes);
            MAP.put(hashMapKey, version);
        }
    }
}

