/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.modifiablevariable.util.DataConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public enum TokenBindingVersion {
    DRAFT_1(new byte[]{0, 1}),
    DRAFT_2(new byte[]{0, 2}),
    DRAFT_3(new byte[]{0, 3}),
    DRAFT_4(new byte[]{0, 4}),
    DRAFT_5(new byte[]{0, 5}),
    DRAFT_6(new byte[]{0, 6}),
    DRAFT_7(new byte[]{0, 7}),
    DRAFT_8(new byte[]{0, 8}),
    DRAFT_9(new byte[]{0, 9}),
    DRAFT_10(new byte[]{0, 10}),
    DRAFT_11(new byte[]{0, 11}),
    DRAFT_12(new byte[]{0, 12}),
    DRAFT_13(new byte[]{0, 13}),
    DRAFT_14(new byte[]{0, 14}),
    DRAFT_15(new byte[]{0, 15}),
    DRAFT_16(new byte[]{0, 16}),
    DRAFT_17(new byte[]{0, 17}),
    DRAFT_18(new byte[]{0, 18});

    private final byte[] tokenBindingVersion;
    public static final int LENGTH = 2;
    private static final Map<Integer, TokenBindingVersion> MAP;

    private TokenBindingVersion(byte[] tokenBindingVersion) {
        this.tokenBindingVersion = tokenBindingVersion;
    }

    public byte[] getByteValue() {
        return this.tokenBindingVersion;
    }

    public static TokenBindingVersion getExtensionType(byte[] value) {
        TokenBindingVersion type = MAP.get(DataConverter.bytesToInt((byte[])value));
        return type;
    }

    public byte getMajor() {
        return this.tokenBindingVersion[0];
    }

    public byte getMinor() {
        return this.tokenBindingVersion[1];
    }

    public static TokenBindingVersion getRandom(Random random) {
        TokenBindingVersion c = null;
        while (c == null) {
            Object[] o = MAP.values().toArray();
            c = (TokenBindingVersion)((Object)o[random.nextInt(o.length)]);
        }
        return c;
    }

    static {
        MAP = new HashMap<Integer, TokenBindingVersion>();
        for (TokenBindingVersion c : TokenBindingVersion.values()) {
            MAP.put(DataConverter.bytesToInt((byte[])c.tokenBindingVersion), c);
        }
    }
}

