/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.HashAlgorithm;
import de.rub.nds.protocol.constants.SignatureAlgorithm;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum SignatureAndHashAlgorithm {
    ANONYMOUS_NONE(0, null, null),
    ANONYMOUS_MD5(256, null, HashAlgorithm.MD5),
    ANONYMOUS_SHA1(512, null, HashAlgorithm.SHA1),
    ANONYMOUS_SHA224(768, null, HashAlgorithm.SHA224),
    ANONYMOUS_SHA256(1024, null, HashAlgorithm.SHA256),
    ANONYMOUS_SHA384(1280, null, HashAlgorithm.SHA384),
    ANONYMOUS_SHA512(1536, null, HashAlgorithm.SHA512),
    RSA_NONE(1, SignatureAlgorithm.RSA_PKCS1, null),
    RSA_MD5(257, SignatureAlgorithm.RSA_PKCS1, HashAlgorithm.MD5),
    RSA_SHA1(513, SignatureAlgorithm.RSA_PKCS1, HashAlgorithm.SHA1),
    RSA_SHA224(769, SignatureAlgorithm.RSA_PKCS1, HashAlgorithm.SHA224),
    RSA_SHA256(1025, SignatureAlgorithm.RSA_PKCS1, HashAlgorithm.SHA256),
    RSA_SHA384(1281, SignatureAlgorithm.RSA_PKCS1, HashAlgorithm.SHA384),
    RSA_SHA512(1537, SignatureAlgorithm.RSA_PKCS1, HashAlgorithm.SHA512),
    DSA_NONE(2, SignatureAlgorithm.DSA, null),
    DSA_MD5(258, SignatureAlgorithm.DSA, HashAlgorithm.MD5),
    DSA_SHA1(514, SignatureAlgorithm.DSA, HashAlgorithm.SHA1),
    DSA_SHA224(770, SignatureAlgorithm.DSA, HashAlgorithm.SHA224),
    DSA_SHA256(1026, SignatureAlgorithm.DSA, HashAlgorithm.SHA256),
    DSA_SHA384(1282, SignatureAlgorithm.DSA, HashAlgorithm.SHA384),
    DSA_SHA512(1538, SignatureAlgorithm.DSA, HashAlgorithm.SHA512),
    ECDSA_NONE(3, SignatureAlgorithm.ECDSA, null),
    ECDSA_MD5(259, SignatureAlgorithm.ECDSA, HashAlgorithm.MD5),
    ECDSA_SHA1(515, SignatureAlgorithm.ECDSA, HashAlgorithm.SHA1),
    ECDSA_SHA224(771, SignatureAlgorithm.ECDSA, HashAlgorithm.SHA224),
    ECDSA_SHA256(1027, SignatureAlgorithm.ECDSA, HashAlgorithm.SHA256),
    ECDSA_SHA384(1283, SignatureAlgorithm.ECDSA, HashAlgorithm.SHA384),
    ECDSA_SHA512(1539, SignatureAlgorithm.ECDSA, HashAlgorithm.SHA512),
    SM2_SM3(1800, SignatureAlgorithm.ECDSA, HashAlgorithm.SM3),
    ED25519(2055, SignatureAlgorithm.ED25519, HashAlgorithm.SHA256),
    ED448(2056, SignatureAlgorithm.ED448, HashAlgorithm.SHA3_256),
    RSA_PSS_RSAE_SHA256(2052, SignatureAlgorithm.RSA_SSA_PSS, HashAlgorithm.SHA256),
    RSA_PSS_RSAE_SHA384(2053, SignatureAlgorithm.RSA_SSA_PSS, HashAlgorithm.SHA384),
    RSA_PSS_RSAE_SHA512(2054, SignatureAlgorithm.RSA_SSA_PSS, HashAlgorithm.SHA512),
    RSA_PSS_PSS_SHA256(2057, SignatureAlgorithm.RSA_SSA_PSS, HashAlgorithm.SHA256),
    RSA_PSS_PSS_SHA384(2058, SignatureAlgorithm.RSA_SSA_PSS, HashAlgorithm.SHA384),
    RSA_PSS_PSS_SHA512(2059, SignatureAlgorithm.RSA_SSA_PSS, HashAlgorithm.SHA512),
    GOSTR34102001_GOSTR3411(60909, SignatureAlgorithm.GOSTR34102001, null),
    GOSTR34102012_256_GOSTR34112012_256(61166, SignatureAlgorithm.GOSTR34102012_256, null),
    GOSTR34102012_512_GOSTR34112012_512(61423, SignatureAlgorithm.GOSTR34102001, null),
    ECDSA_BRAINPOOL_P256R1_TLS13_SHA256(2074, SignatureAlgorithm.ECDSA, HashAlgorithm.SHA256),
    ECDSA_BRAINPOOL_P384R1_TLS13_SHA384(2075, SignatureAlgorithm.ECDSA, HashAlgorithm.SHA384),
    ECDSA_BRAINPOOL_P512R1_TLS13_SHA512(2076, SignatureAlgorithm.ECDSA, HashAlgorithm.SHA512),
    GREASE_00(2570, null, null),
    GREASE_01(6682, null, null),
    GREASE_02(10794, null, null),
    GREASE_03(14906, null, null),
    GREASE_04(19018, null, null),
    GREASE_05(23130, null, null),
    GREASE_06(27242, null, null),
    GREASE_07(31354, null, null),
    GREASE_08(35466, null, null),
    GREASE_09(39578, null, null),
    GREASE_10(43690, null, null),
    GREASE_11(47802, null, null),
    GREASE_12(51914, null, null),
    GREASE_13(56026, null, null),
    GREASE_14(60138, null, null),
    GREASE_15(64250, null, null);

    private static final Logger LOGGER;
    private int value;
    private HashAlgorithm hashAlgorithm;
    private SignatureAlgorithm signatureAlgorithm;
    private static final Map<Integer, SignatureAndHashAlgorithm> MAP;

    public static List<? extends SignatureAndHashAlgorithm> getImplemented() {
        LinkedList<SignatureAndHashAlgorithm> algoList = new LinkedList<SignatureAndHashAlgorithm>();
        algoList.add(DSA_SHA1);
        algoList.add(DSA_SHA224);
        algoList.add(DSA_SHA256);
        algoList.add(DSA_SHA384);
        algoList.add(DSA_SHA512);
        algoList.add(RSA_MD5);
        algoList.add(RSA_SHA1);
        algoList.add(RSA_SHA224);
        algoList.add(RSA_SHA256);
        algoList.add(RSA_SHA384);
        algoList.add(RSA_SHA512);
        algoList.add(ECDSA_SHA1);
        algoList.add(ECDSA_SHA224);
        algoList.add(ECDSA_SHA256);
        algoList.add(ECDSA_SHA384);
        algoList.add(ECDSA_SHA512);
        algoList.add(RSA_PSS_RSAE_SHA256);
        algoList.add(RSA_PSS_RSAE_SHA384);
        algoList.add(RSA_PSS_RSAE_SHA512);
        algoList.add(RSA_PSS_PSS_SHA256);
        algoList.add(RSA_PSS_PSS_SHA384);
        algoList.add(RSA_PSS_PSS_SHA512);
        algoList.add(SM2_SM3);
        return algoList;
    }

    public static List<SignatureAndHashAlgorithm> getTls13SignatureAndHashAlgorithms() {
        LinkedList<SignatureAndHashAlgorithm> algos = new LinkedList<SignatureAndHashAlgorithm>();
        algos.add(RSA_SHA256);
        algos.add(RSA_SHA384);
        algos.add(RSA_SHA512);
        algos.add(ECDSA_SHA256);
        algos.add(ECDSA_SHA384);
        algos.add(ECDSA_SHA512);
        algos.add(RSA_PSS_PSS_SHA256);
        algos.add(RSA_PSS_PSS_SHA384);
        algos.add(RSA_PSS_PSS_SHA512);
        algos.add(RSA_PSS_RSAE_SHA256);
        algos.add(RSA_PSS_RSAE_SHA384);
        algos.add(RSA_PSS_RSAE_SHA512);
        algos.add(ED448);
        algos.add(ED25519);
        algos.add(ECDSA_BRAINPOOL_P256R1_TLS13_SHA256);
        algos.add(ECDSA_BRAINPOOL_P384R1_TLS13_SHA384);
        algos.add(ECDSA_BRAINPOOL_P512R1_TLS13_SHA512);
        algos.add(SM2_SM3);
        return algos;
    }

    public static List<SignatureAndHashAlgorithm> getImplementedTls13SignatureAndHashAlgorithms() {
        return SignatureAndHashAlgorithm.getTls13SignatureAndHashAlgorithms().stream().filter(algorithm -> SignatureAndHashAlgorithm.getImplemented().contains(algorithm)).collect(Collectors.toList());
    }

    private SignatureAndHashAlgorithm(int value, SignatureAlgorithm signatureAlgorithm, HashAlgorithm hashAlgorithm) {
        this.value = value;
        this.hashAlgorithm = hashAlgorithm;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    private static int valueToInt(byte[] value) {
        if (value.length >= 2) {
            return (value[0] & 0xFF) << 8 | value[1] & 0xFF;
        }
        if (value.length == 1) {
            return value[0];
        }
        return 0;
    }

    public static List<SignatureAndHashAlgorithm> getSignatureAndHashAlgorithms(byte[] signatureAndHashBytes) {
        LinkedList<SignatureAndHashAlgorithm> algoList = new LinkedList<SignatureAndHashAlgorithm>();
        if (signatureAndHashBytes.length % 2 != 0) {
            throw new ParserException("Error while parsing signatureAndHashAlgorithm Bytes");
        }
        ByteArrayInputStream algorithmsStream = new ByteArrayInputStream(signatureAndHashBytes);
        byte[] algoBytes = new byte[2];
        while (algorithmsStream.read(algoBytes, 0, 2) != -1) {
            SignatureAndHashAlgorithm algo = SignatureAndHashAlgorithm.getSignatureAndHashAlgorithm(algoBytes);
            if (algo == null) {
                LOGGER.warn("Unknown SignatureAndHashAlgorithm: {}", (Object)algoBytes);
                continue;
            }
            algoList.add(algo);
        }
        return algoList;
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(byte[] value) {
        return SignatureAndHashAlgorithm.getSignatureAndHashAlgorithm(SignatureAndHashAlgorithm.valueToInt(value));
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(int value) {
        SignatureAndHashAlgorithm sigHashAlgo = MAP.get(value);
        return sigHashAlgo;
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(SignatureAlgorithm signatureAlgo, HashAlgorithm hashAlgo) {
        for (SignatureAndHashAlgorithm algo : SignatureAndHashAlgorithm.values()) {
            if (algo.getHashAlgorithm() != hashAlgo || algo.getSignatureAlgorithm() != signatureAlgo) continue;
            return algo;
        }
        throw new UnsupportedOperationException("Requested SignatureHashAlgorithm is not supported. Requested Sign:" + String.valueOf(signatureAlgo) + " Hash:" + String.valueOf(hashAlgo));
    }

    public byte[] getByteValue() {
        return DataConverter.intToBytes((int)this.value, (int)2);
    }

    public int getValue() {
        return this.value;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public boolean suitedForSigningTls13Messages() {
        switch (this.ordinal()) {
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return true;
            }
        }
        return false;
    }

    public boolean suitedForSigningTls13Certs() {
        switch (this.ordinal()) {
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 28: {
                return true;
            }
        }
        return this.suitedForSigningTls13Messages();
    }

    public boolean isGrease() {
        return this.name().startsWith("GREASE");
    }

    public boolean isRsaPssRsae() {
        return this == RSA_PSS_RSAE_SHA256 || this == RSA_PSS_RSAE_SHA384 || this == RSA_PSS_RSAE_SHA512;
    }

    public boolean suitableForSignatureKeyType(X509PublicKeyType publicKeyType) {
        if (this.isRsaPssRsae()) {
            return publicKeyType == X509PublicKeyType.RSA;
        }
        try {
            boolean usable = publicKeyType.canBeUsedWithSignatureAlgorithm(this.getSignatureAlgorithm());
            return usable;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        MAP = new HashMap<Integer, SignatureAndHashAlgorithm>();
        for (SignatureAndHashAlgorithm c : SignatureAndHashAlgorithm.values()) {
            MAP.put(c.value, c);
        }
    }
}

