/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum PskKeyExchangeMode {
    PSK_KE(0),
    PSK_DHE_KE(1);

    private byte value;
    private static final Map<Byte, PskKeyExchangeMode> MAP;
    private static final Logger LOGGER;

    private PskKeyExchangeMode(byte value) {
        this.value = value;
    }

    public static PskKeyExchangeMode getExchangeMode(byte value) {
        return MAP.get(value);
    }

    public static List<PskKeyExchangeMode> getExchangeModes(byte[] sourceBytes) {
        if (sourceBytes == null || sourceBytes.length == 0) {
            return new ArrayList<PskKeyExchangeMode>();
        }
        ArrayList<PskKeyExchangeMode> modes = new ArrayList<PskKeyExchangeMode>(sourceBytes.length);
        for (byte sourceByte : sourceBytes) {
            PskKeyExchangeMode mode = PskKeyExchangeMode.getExchangeMode(sourceByte);
            if (mode != null) {
                modes.add(mode);
                continue;
            }
            LOGGER.warn("Ignoring unknown PskKeyExchangeMode {}", (Object)sourceByte);
        }
        return modes;
    }

    public byte getValue() {
        return this.value;
    }

    static {
        LOGGER = LogManager.getLogger();
        MAP = new HashMap<Byte, PskKeyExchangeMode>();
        for (PskKeyExchangeMode cm : PskKeyExchangeMode.values()) {
            MAP.put(cm.value, cm);
        }
    }
}

