/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.HashMap;
import java.util.Map;

public enum ProtocolMessageType {
    UNKNOWN(99),
    CHANGE_CIPHER_SPEC(20),
    ALERT(21),
    HANDSHAKE(22),
    APPLICATION_DATA(23),
    HEARTBEAT(24),
    TLS12_CID(25),
    ACK(26);

    private byte value;
    private static final Map<Byte, ProtocolMessageType> MAP;

    private ProtocolMessageType(byte value) {
        this.value = value;
    }

    public static ProtocolMessageType getContentType(byte value) {
        return MAP.get(value);
    }

    public byte getValue() {
        return this.value;
    }

    public byte[] getArrayValue() {
        return new byte[]{this.value};
    }

    static {
        MAP = new HashMap<Byte, ProtocolMessageType>();
        for (ProtocolMessageType cm : ProtocolMessageType.values()) {
            MAP.put(cm.value, cm);
        }
    }
}

