/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.HashAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherType;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.exceptions.UnknownCipherSuiteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum CipherSuite {
    TLS_NULL_WITH_NULL_NULL(0, CipherType.STREAM, KeyExchangeAlgorithm.NULL, CipherAlgorithm.NULL, HashAlgorithm.NONE, false, false),
    TLS_RSA_WITH_NULL_MD5(1, CipherType.STREAM, KeyExchangeAlgorithm.RSA, CipherAlgorithm.NULL, HashAlgorithm.MD5, false, false),
    TLS_RSA_WITH_NULL_SHA(2, CipherType.STREAM, KeyExchangeAlgorithm.RSA, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    TLS_RSA_EXPORT_WITH_RC4_40_MD5(3, CipherType.STREAM, KeyExchangeAlgorithm.RSA, CipherAlgorithm.RC4_40, HashAlgorithm.MD5, true, false),
    TLS_RSA_WITH_RC4_128_MD5(4, CipherType.STREAM, KeyExchangeAlgorithm.RSA, CipherAlgorithm.RC4_128, HashAlgorithm.MD5, false, false),
    TLS_RSA_WITH_RC4_128_SHA(5, CipherType.STREAM, KeyExchangeAlgorithm.RSA, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5(6, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.RC2_40, HashAlgorithm.MD5, false, false),
    TLS_RSA_WITH_IDEA_CBC_SHA(7, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.IDEA_128, HashAlgorithm.SHA1, false, false),
    TLS_RSA_EXPORT_WITH_DES40_CBC_SHA(8, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.DES40_CBC, HashAlgorithm.SHA1, true, false),
    TLS_RSA_WITH_DES_CBC_SHA(9, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, false, false),
    TLS_RSA_WITH_3DES_EDE_CBC_SHA(10, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA(11, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.DES40_CBC, HashAlgorithm.SHA1, true, false),
    TLS_DH_DSS_WITH_DES_CBC_SHA(12, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA(13, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA(14, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.DES40_CBC, HashAlgorithm.SHA1, true, false),
    TLS_DH_RSA_WITH_DES_CBC_SHA(15, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA(16, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA(17, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.DES40_CBC, HashAlgorithm.SHA1, true, false),
    TLS_DHE_DSS_WITH_DES_CBC_SHA(18, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA(19, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA(20, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.DES40_CBC, HashAlgorithm.SHA1, true, false),
    TLS_DHE_RSA_WITH_DES_CBC_SHA(21, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA(22, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_anon_EXPORT_WITH_RC4_40_MD5(23, CipherType.STREAM, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.RC4_40, HashAlgorithm.MD5, true, false),
    TLS_DH_anon_WITH_RC4_128_MD5(24, CipherType.STREAM, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.RC4_128, HashAlgorithm.MD5, false, false),
    TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA(25, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.DES40_CBC, HashAlgorithm.SHA1, true, false),
    TLS_DH_anon_WITH_DES_CBC_SHA(26, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_anon_WITH_3DES_EDE_CBC_SHA(27, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    SSL_FORTEZZA_KEA_WITH_NULL_SHA(28, CipherType.STREAM, KeyExchangeAlgorithm.FORTEZZA_KEA, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    SSL_FORTEZZA_KEA_WITH_FORTEZZA_CBC_SHA(29, CipherType.BLOCK, KeyExchangeAlgorithm.FORTEZZA_KEA, CipherAlgorithm.FORTEZZA_CBC, HashAlgorithm.SHA1, false, false),
    TLS_KRB5_WITH_DES_CBC_SHA(30, CipherType.BLOCK, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, false, false),
    TLS_KRB5_WITH_3DES_EDE_CBC_SHA(31, CipherType.BLOCK, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_KRB5_WITH_RC4_128_SHA(32, CipherType.STREAM, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    TLS_KRB5_WITH_IDEA_CBC_SHA(33, CipherType.BLOCK, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.IDEA_128, HashAlgorithm.SHA1, false, false),
    TLS_KRB5_WITH_DES_CBC_MD5(34, CipherType.BLOCK, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.DES_CBC, HashAlgorithm.MD5, false, false),
    TLS_KRB5_WITH_3DES_EDE_CBC_MD5(35, CipherType.BLOCK, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.MD5, false, false),
    TLS_KRB5_WITH_RC4_128_MD5(36, CipherType.STREAM, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.RC4_128, HashAlgorithm.MD5, false, false),
    TLS_KRB5_WITH_IDEA_CBC_MD5(37, CipherType.BLOCK, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.IDEA_128, HashAlgorithm.MD5, false, false),
    TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA(38, CipherType.BLOCK, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, true, false),
    TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA(39, CipherType.BLOCK, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.RC2_40, HashAlgorithm.SHA1, true, false),
    TLS_KRB5_EXPORT_WITH_RC4_40_SHA(40, CipherType.STREAM, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.RC4_40, HashAlgorithm.SHA1, true, false),
    TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5(41, CipherType.BLOCK, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.DES_CBC, HashAlgorithm.MD5, true, false),
    TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5(42, CipherType.BLOCK, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.RC2_40, HashAlgorithm.MD5, true, false),
    TLS_KRB5_EXPORT_WITH_RC4_40_MD5(43, CipherType.STREAM, KeyExchangeAlgorithm.KRB5, CipherAlgorithm.RC4_40, HashAlgorithm.MD5, true, false),
    TLS_PSK_WITH_NULL_SHA(44, CipherType.STREAM, KeyExchangeAlgorithm.PSK, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    TLS_DHE_PSK_WITH_NULL_SHA(45, CipherType.STREAM, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    TLS_RSA_PSK_WITH_NULL_SHA(46, CipherType.STREAM, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    TLS_RSA_WITH_AES_128_CBC_SHA(47, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_DSS_WITH_AES_128_CBC_SHA(48, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_RSA_WITH_AES_128_CBC_SHA(49, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA(50, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA(51, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_anon_WITH_AES_128_CBC_SHA(52, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_RSA_WITH_AES_256_CBC_SHA(53, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_DSS_WITH_AES_256_CBC_SHA(54, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_RSA_WITH_AES_256_CBC_SHA(55, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA(56, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA(57, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_anon_WITH_AES_256_CBC_SHA(58, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_RSA_WITH_NULL_SHA256(59, CipherType.STREAM, KeyExchangeAlgorithm.RSA, CipherAlgorithm.NULL, HashAlgorithm.SHA256, false, false),
    TLS_RSA_WITH_AES_128_CBC_SHA256(60, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_RSA_WITH_AES_256_CBC_SHA256(61, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_DSS_WITH_AES_128_CBC_SHA256(62, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_RSA_WITH_AES_128_CBC_SHA256(63, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA256(64, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA(65, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA(66, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA(67, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA(68, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA(69, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA(70, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_ECDSA_WITH_NULL_SHA(71, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_ECDSA_WITH_RC4_128_SHA(72, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_ECDSA_WITH_DES_CBC_SHA(73, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA(74, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_ECNRA_WITH_NULL_SHA(75, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_ECNRA, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_ECNRA_WITH_RC4_128_SHA(76, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_ECNRA, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_ECNRA_WITH_DES_CBC_SHA(77, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECNRA, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_ECNRA_WITH_3DES_EDE_CBC_SHA(78, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECNRA, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECMQV_ECDSA_WITH_NULL_SHA(79, CipherType.STREAM, KeyExchangeAlgorithm.ECMQV_ECDSA, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECMQV_ECDSA_WITH_RC4_128_SHA(80, CipherType.STREAM, KeyExchangeAlgorithm.ECMQV_ECDSA, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECMQV_ECDSA_WITH_DES_CBC_SHA(81, CipherType.BLOCK, KeyExchangeAlgorithm.ECMQV_ECDSA, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECMQV_ECDSA_WITH_3DES_EDE_CBC_SHA(82, CipherType.BLOCK, KeyExchangeAlgorithm.ECMQV_ECDSA, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECMQV_ECNRA_WITH_NULL_SHA(83, CipherType.STREAM, KeyExchangeAlgorithm.ECMQV_ECNRA, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECMQV_ECNRA_WITH_RC4_128_SHA(84, CipherType.STREAM, KeyExchangeAlgorithm.ECMQV_ECNRA, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECMQV_ECNRA_WITH_DES_CBC_SHA(85, CipherType.BLOCK, KeyExchangeAlgorithm.ECMQV_ECNRA, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECMQV_ECNRA_WITH_3DES_EDE_CBC_SHA(86, CipherType.BLOCK, KeyExchangeAlgorithm.ECMQV_ECNRA, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_anon_WITH_NULL_SHA(87, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_ANON, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_anon_WITH_RC4_128_SHA(88, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_ANON, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_anon_WITH_DES_CBC_SHA(89, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ANON, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA(90, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ANON, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    UNOFFICIAL_TLS_ECDH_anon_EXPORT_WITH_DES40_CBC_SHA(91, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ANON, CipherAlgorithm.DES40_CBC, HashAlgorithm.SHA1, true, false),
    UNOFFICIAL_TLS_ECDH_anon_EXPORT_WITH_RC4_40_SHA(92, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_ANON, CipherAlgorithm.RC4_40, HashAlgorithm.SHA1, true, false),
    TLS_RSA_EXPORT1024_WITH_RC4_56_MD5(96, CipherType.STREAM, KeyExchangeAlgorithm.RSA_EXPORT, CipherAlgorithm.RC4_56, HashAlgorithm.MD5, true, false),
    TLS_RSA_EXPORT1024_WITH_RC2_56_MD5(97, CipherType.BLOCK, KeyExchangeAlgorithm.RSA_EXPORT, CipherAlgorithm.RC2_56, HashAlgorithm.MD5, true, false),
    TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA(98, CipherType.BLOCK, KeyExchangeAlgorithm.RSA_EXPORT, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, true, false),
    TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA(99, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.DES_CBC, HashAlgorithm.SHA1, true, false),
    TLS_RSA_EXPORT1024_WITH_RC4_56_SHA(100, CipherType.STREAM, KeyExchangeAlgorithm.RSA_EXPORT, CipherAlgorithm.RC4_56, HashAlgorithm.SHA1, true, false),
    TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA(101, CipherType.STREAM, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.RC4_56, HashAlgorithm.SHA1, true, false),
    TLS_DHE_DSS_WITH_RC4_128_SHA(102, CipherType.STREAM, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA256(103, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_DSS_WITH_AES_256_CBC_SHA256(104, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_RSA_WITH_AES_256_CBC_SHA256(105, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA256(106, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA256(107, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_anon_WITH_AES_128_CBC_SHA256(108, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_anon_WITH_AES_256_CBC_SHA256(109, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA256, false, false),
    TLS_GOSTR341094_WITH_28147_CNT_IMIT(128, CipherType.STREAM, KeyExchangeAlgorithm.VKO_GOST94, CipherAlgorithm.GOST_28147_CNT_IMIT, HashAlgorithm.GOST_R3411_94, false, false),
    TLS_GOSTR341001_WITH_28147_CNT_IMIT(129, CipherType.STREAM, KeyExchangeAlgorithm.VKO_GOST01, CipherAlgorithm.GOST_28147_CNT_IMIT, HashAlgorithm.GOST_R3411_94, false, false),
    TLS_GOSTR341094_WITH_NULL_GOSTR3411(130, CipherType.STREAM, KeyExchangeAlgorithm.VKO_GOST94, CipherAlgorithm.NULL, HashAlgorithm.GOST_R3411_94, false, false),
    TLS_GOSTR341001_WITH_NULL_GOSTR3411(131, CipherType.STREAM, KeyExchangeAlgorithm.VKO_GOST01, CipherAlgorithm.NULL, HashAlgorithm.GOST_R3411_94, false, false),
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA(132, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA(133, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA(134, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA(135, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA(136, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA(137, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_PSK_WITH_RC4_128_SHA(138, CipherType.STREAM, KeyExchangeAlgorithm.PSK, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    TLS_PSK_WITH_3DES_EDE_CBC_SHA(139, CipherType.BLOCK, KeyExchangeAlgorithm.PSK, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_PSK_WITH_AES_128_CBC_SHA(140, CipherType.BLOCK, KeyExchangeAlgorithm.PSK, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_PSK_WITH_AES_256_CBC_SHA(141, CipherType.BLOCK, KeyExchangeAlgorithm.PSK, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_PSK_WITH_RC4_128_SHA(142, CipherType.STREAM, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA(143, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA(144, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA(145, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_RSA_PSK_WITH_RC4_128_SHA(146, CipherType.STREAM, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA(147, CipherType.BLOCK, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA(148, CipherType.BLOCK, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA(149, CipherType.BLOCK, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_RSA_WITH_SEED_CBC_SHA(150, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.SEED_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_DSS_WITH_SEED_CBC_SHA(151, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.SEED_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_RSA_WITH_SEED_CBC_SHA(152, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.SEED_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_DSS_WITH_SEED_CBC_SHA(153, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.SEED_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DHE_RSA_WITH_SEED_CBC_SHA(154, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.SEED_CBC, HashAlgorithm.SHA1, false, false),
    TLS_DH_anon_WITH_SEED_CBC_SHA(155, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.SEED_CBC, HashAlgorithm.SHA1, false, false),
    TLS_RSA_WITH_AES_128_GCM_SHA256(156, CipherType.AEAD, KeyExchangeAlgorithm.RSA, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_RSA_WITH_AES_256_GCM_SHA384(157, CipherType.AEAD, KeyExchangeAlgorithm.RSA, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DHE_RSA_WITH_AES_128_GCM_SHA256(158, CipherType.AEAD, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_RSA_WITH_AES_256_GCM_SHA384(159, CipherType.AEAD, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DH_RSA_WITH_AES_128_GCM_SHA256(160, CipherType.AEAD, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DH_RSA_WITH_AES_256_GCM_SHA384(161, CipherType.AEAD, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DHE_DSS_WITH_AES_128_GCM_SHA256(162, CipherType.AEAD, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_DSS_WITH_AES_256_GCM_SHA384(163, CipherType.AEAD, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DH_DSS_WITH_AES_128_GCM_SHA256(164, CipherType.AEAD, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DH_DSS_WITH_AES_256_GCM_SHA384(165, CipherType.AEAD, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DH_anon_WITH_AES_128_GCM_SHA256(166, CipherType.AEAD, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DH_anon_WITH_AES_256_GCM_SHA384(167, CipherType.AEAD, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_PSK_WITH_AES_128_GCM_SHA256(168, CipherType.AEAD, KeyExchangeAlgorithm.PSK, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_PSK_WITH_AES_256_GCM_SHA384(169, CipherType.AEAD, KeyExchangeAlgorithm.PSK, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DHE_PSK_WITH_AES_128_GCM_SHA256(170, CipherType.AEAD, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_PSK_WITH_AES_256_GCM_SHA384(171, CipherType.AEAD, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_RSA_PSK_WITH_AES_128_GCM_SHA256(172, CipherType.AEAD, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_RSA_PSK_WITH_AES_256_GCM_SHA384(173, CipherType.AEAD, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_PSK_WITH_AES_128_CBC_SHA256(174, CipherType.BLOCK, KeyExchangeAlgorithm.PSK, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_PSK_WITH_AES_256_CBC_SHA384(175, CipherType.BLOCK, KeyExchangeAlgorithm.PSK, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_PSK_WITH_NULL_SHA256(176, CipherType.STREAM, KeyExchangeAlgorithm.PSK, CipherAlgorithm.NULL, HashAlgorithm.SHA256, false, false),
    TLS_PSK_WITH_NULL_SHA384(177, CipherType.STREAM, KeyExchangeAlgorithm.PSK, CipherAlgorithm.NULL, HashAlgorithm.SHA384, false, false),
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA256(178, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA384(179, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_DHE_PSK_WITH_NULL_SHA256(180, CipherType.STREAM, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.NULL, HashAlgorithm.SHA256, false, false),
    TLS_DHE_PSK_WITH_NULL_SHA384(181, CipherType.STREAM, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.NULL, HashAlgorithm.SHA384, false, false),
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA256(182, CipherType.BLOCK, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA384(183, CipherType.BLOCK, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_RSA_PSK_WITH_NULL_SHA256(184, CipherType.STREAM, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.NULL, HashAlgorithm.SHA256, false, false),
    TLS_RSA_PSK_WITH_NULL_SHA384(185, CipherType.STREAM, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.NULL, HashAlgorithm.SHA384, false, false),
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256(186, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256(187, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256(188, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256(189, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256(190, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256(191, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256(192, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256(193, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256(194, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256(195, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256(196, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256(197, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA256, false, false),
    TLS_SM4_GCM_SM3(198, CipherType.AEAD, null, CipherAlgorithm.SM4_GCM, HashAlgorithm.SM3, false, true),
    TLS_SM4_CCM_SM3(199, CipherType.AEAD, null, CipherAlgorithm.SM4_CCM, HashAlgorithm.SM3, false, true),
    TLS_EMPTY_RENEGOTIATION_INFO_SCSV(255, false),
    TLS_AES_128_GCM_SHA256(4865, CipherType.AEAD, null, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, true),
    TLS_AES_256_GCM_SHA384(4866, CipherType.AEAD, null, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, true),
    TLS_CHACHA20_POLY1305_SHA256(4867, CipherType.AEAD, null, CipherAlgorithm.CHACHA20_POLY1305, HashAlgorithm.SHA256, false, true),
    TLS_AES_128_CCM_SHA256(4868, CipherType.AEAD, null, CipherAlgorithm.AES_128_CCM, HashAlgorithm.SHA256, false, true),
    TLS_AES_128_CCM_8_SHA256(4869, CipherType.AEAD, null, CipherAlgorithm.AES_128_CCM_8, HashAlgorithm.SHA256, false, true),
    TLS_FALLBACK_SCSV(22016, false),
    TLS_ECDH_ECDSA_WITH_NULL_SHA(49153, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_ECDSA_WITH_RC4_128_SHA(49154, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA(49155, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA(49156, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA(49157, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_ECDSA_WITH_NULL_SHA(49158, CipherType.STREAM, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_ECDSA_WITH_RC4_128_SHA(49159, CipherType.STREAM, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA(49160, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA(49161, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA(49162, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_RSA_WITH_NULL_SHA(49163, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_RSA_WITH_RC4_128_SHA(49164, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA(49165, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA(49166, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA(49167, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_RSA_WITH_NULL_SHA(49168, CipherType.STREAM, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_RSA_WITH_RC4_128_SHA(49169, CipherType.STREAM, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA(49170, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA(49171, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA(49172, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_anon_WITH_NULL_SHA(49173, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_ANON, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_anon_WITH_RC4_128_SHA(49174, CipherType.STREAM, KeyExchangeAlgorithm.ECDH_ANON, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA(49175, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ANON, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_anon_WITH_AES_128_CBC_SHA(49176, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ANON, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDH_anon_WITH_AES_256_CBC_SHA(49177, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ANON, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA(49178, CipherType.BLOCK, KeyExchangeAlgorithm.SRP_SHA, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA(49179, CipherType.BLOCK, KeyExchangeAlgorithm.SRP_SHA_RSA, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA(49180, CipherType.BLOCK, KeyExchangeAlgorithm.SRP_SHA_DSS, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_SRP_SHA_WITH_AES_128_CBC_SHA(49181, CipherType.BLOCK, KeyExchangeAlgorithm.SRP_SHA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA(49182, CipherType.BLOCK, KeyExchangeAlgorithm.SRP_SHA_RSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA(49183, CipherType.BLOCK, KeyExchangeAlgorithm.SRP_SHA_DSS, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_SRP_SHA_WITH_AES_256_CBC_SHA(49184, CipherType.BLOCK, KeyExchangeAlgorithm.SRP_SHA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA(49185, CipherType.BLOCK, KeyExchangeAlgorithm.SRP_SHA_RSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA(49186, CipherType.BLOCK, KeyExchangeAlgorithm.SRP_SHA_DSS, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256(49187, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384(49188, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256(49189, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384(49190, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256(49191, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384(49192, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256(49193, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384(49194, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256(49195, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384(49196, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256(49197, CipherType.AEAD, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384(49198, CipherType.AEAD, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256(49199, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384(49200, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256(49201, CipherType.AEAD, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384(49202, CipherType.AEAD, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_PSK_WITH_RC4_128_SHA(49203, CipherType.STREAM, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.RC4_128, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA(49204, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.DES_EDE_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA(49205, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA(49206, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256(49207, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.AES_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384(49208, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.AES_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_PSK_WITH_NULL_SHA(49209, CipherType.STREAM, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.NULL, HashAlgorithm.SHA1, false, false),
    TLS_ECDHE_PSK_WITH_NULL_SHA256(49210, CipherType.STREAM, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.NULL, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_PSK_WITH_NULL_SHA384(49211, CipherType.STREAM, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.NULL, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256(53249, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384(53250, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256(53251, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.AES_128_CCM_8, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256(53253, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.AES_128_CCM, HashAlgorithm.SHA256, false, false),
    TLS_RSA_WITH_ARIA_128_CBC_SHA256(49212, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_RSA_WITH_ARIA_256_CBC_SHA384(49213, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256(49214, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384(49215, CipherType.BLOCK, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256(49216, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384(49217, CipherType.BLOCK, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256(49218, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384(49219, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256(49220, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384(49221, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_DH_anon_WITH_ARIA_128_CBC_SHA256(49222, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DH_anon_WITH_ARIA_256_CBC_SHA384(49223, CipherType.BLOCK, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256(49224, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384(49225, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256(49226, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384(49227, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256(49228, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384(49229, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256(49230, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384(49231, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_RSA_WITH_ARIA_128_GCM_SHA256(49232, CipherType.AEAD, KeyExchangeAlgorithm.RSA, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_RSA_WITH_ARIA_256_GCM_SHA384(49233, CipherType.AEAD, KeyExchangeAlgorithm.RSA, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256(49234, CipherType.AEAD, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384(49235, CipherType.AEAD, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256(49236, CipherType.AEAD, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384(49237, CipherType.AEAD, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256(49238, CipherType.AEAD, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384(49239, CipherType.AEAD, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256(49240, CipherType.AEAD, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384(49241, CipherType.AEAD, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DH_anon_WITH_ARIA_128_GCM_SHA256(49242, CipherType.AEAD, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DH_anon_WITH_ARIA_256_GCM_SHA384(49243, CipherType.AEAD, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256(49244, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384(49245, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256(49246, CipherType.AEAD, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384(49247, CipherType.AEAD, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256(49248, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384(49249, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256(49250, CipherType.AEAD, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384(49251, CipherType.AEAD, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_PSK_WITH_ARIA_128_CBC_SHA256(49252, CipherType.BLOCK, KeyExchangeAlgorithm.PSK, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_PSK_WITH_ARIA_256_CBC_SHA384(49253, CipherType.BLOCK, KeyExchangeAlgorithm.PSK, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256(49254, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384(49255, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256(49256, CipherType.BLOCK, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384(49257, CipherType.BLOCK, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_PSK_WITH_ARIA_128_GCM_SHA256(49258, CipherType.AEAD, KeyExchangeAlgorithm.PSK, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_PSK_WITH_ARIA_256_GCM_SHA384(49259, CipherType.AEAD, KeyExchangeAlgorithm.PSK, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256(49260, CipherType.AEAD, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384(49261, CipherType.AEAD, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256(49262, CipherType.AEAD, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.ARIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384(49263, CipherType.AEAD, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.ARIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256(49264, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.ARIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384(49265, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.ARIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256(49266, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384(49267, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256(49268, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384(49269, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256(49270, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384(49271, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256(49272, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384(49273, CipherType.BLOCK, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256(49274, CipherType.AEAD, KeyExchangeAlgorithm.RSA, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384(49275, CipherType.AEAD, KeyExchangeAlgorithm.RSA, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256(49276, CipherType.AEAD, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384(49277, CipherType.AEAD, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256(49278, CipherType.AEAD, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384(49279, CipherType.AEAD, KeyExchangeAlgorithm.DH_RSA, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256(49280, CipherType.AEAD, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384(49281, CipherType.AEAD, KeyExchangeAlgorithm.DHE_DSS, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256(49282, CipherType.AEAD, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384(49283, CipherType.AEAD, KeyExchangeAlgorithm.DH_DSS, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256(49284, CipherType.AEAD, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384(49285, CipherType.AEAD, KeyExchangeAlgorithm.DH_ANON, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256(49286, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384(49287, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256(49288, CipherType.AEAD, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384(49289, CipherType.AEAD, KeyExchangeAlgorithm.ECDH_ECDSA, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256(49290, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384(49291, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256(49292, CipherType.AEAD, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384(49293, CipherType.AEAD, KeyExchangeAlgorithm.ECDH_RSA, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256(49294, CipherType.AEAD, KeyExchangeAlgorithm.PSK, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384(49295, CipherType.AEAD, KeyExchangeAlgorithm.PSK, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256(49296, CipherType.AEAD, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384(49297, CipherType.AEAD, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256(49298, CipherType.AEAD, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.CAMELLIA_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384(49299, CipherType.AEAD, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.CAMELLIA_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256(49300, CipherType.BLOCK, KeyExchangeAlgorithm.PSK, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384(49301, CipherType.BLOCK, KeyExchangeAlgorithm.PSK, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256(49302, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384(49303, CipherType.BLOCK, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256(49304, CipherType.BLOCK, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384(49305, CipherType.BLOCK, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256(49306, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.CAMELLIA_128_CBC, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384(49307, CipherType.BLOCK, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.CAMELLIA_256_CBC, HashAlgorithm.SHA384, false, false),
    TLS_RSA_WITH_AES_128_CCM(49308, CipherType.AEAD, KeyExchangeAlgorithm.RSA, CipherAlgorithm.AES_128_CCM, HashAlgorithm.SHA256, false, false),
    TLS_RSA_WITH_AES_256_CCM(49309, CipherType.AEAD, KeyExchangeAlgorithm.RSA, CipherAlgorithm.AES_256_CCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_RSA_WITH_AES_128_CCM(49310, CipherType.AEAD, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.AES_128_CCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_RSA_WITH_AES_256_CCM(49311, CipherType.AEAD, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.AES_256_CCM, HashAlgorithm.SHA256, false, false),
    TLS_RSA_WITH_AES_128_CCM_8(49312, CipherType.AEAD, KeyExchangeAlgorithm.RSA, CipherAlgorithm.AES_128_CCM_8, HashAlgorithm.SHA256, false, false),
    TLS_RSA_WITH_AES_256_CCM_8(49313, CipherType.AEAD, KeyExchangeAlgorithm.RSA, CipherAlgorithm.AES_256_CCM_8, HashAlgorithm.SHA256, false, false),
    TLS_DHE_RSA_WITH_AES_128_CCM_8(49314, CipherType.AEAD, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.AES_128_CCM_8, HashAlgorithm.SHA256, false, false),
    TLS_DHE_RSA_WITH_AES_256_CCM_8(49315, CipherType.AEAD, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.AES_256_CCM_8, HashAlgorithm.SHA256, false, false),
    TLS_PSK_WITH_AES_128_CCM(49316, CipherType.AEAD, KeyExchangeAlgorithm.PSK, CipherAlgorithm.AES_128_CCM, HashAlgorithm.SHA256, false, false),
    TLS_PSK_WITH_AES_256_CCM(49317, CipherType.AEAD, KeyExchangeAlgorithm.PSK, CipherAlgorithm.AES_256_CCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_PSK_WITH_AES_128_CCM(49318, CipherType.AEAD, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.AES_128_CCM, HashAlgorithm.SHA256, false, false),
    TLS_DHE_PSK_WITH_AES_256_CCM(49319, CipherType.AEAD, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.AES_256_CCM, HashAlgorithm.SHA256, false, false),
    TLS_PSK_WITH_AES_128_CCM_8(49320, CipherType.AEAD, KeyExchangeAlgorithm.PSK, CipherAlgorithm.AES_128_CCM_8, HashAlgorithm.SHA256, false, false),
    TLS_PSK_WITH_AES_256_CCM_8(49321, CipherType.AEAD, KeyExchangeAlgorithm.PSK, CipherAlgorithm.AES_256_CCM_8, HashAlgorithm.SHA256, false, false),
    TLS_PSK_DHE_WITH_AES_128_CCM_8(49322, CipherType.AEAD, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.AES_128_CCM_8, HashAlgorithm.SHA256, false, false),
    TLS_PSK_DHE_WITH_AES_256_CCM_8(49323, CipherType.AEAD, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.AES_256_CCM_8, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM(49324, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.AES_128_CCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM(49325, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.AES_256_CCM, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8(49326, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.AES_128_CCM_8, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8(49327, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.AES_256_CCM_8, HashAlgorithm.SHA256, false, false),
    TLS_ECCPWD_WITH_AES_128_GCM_SHA256(49328, CipherType.AEAD, KeyExchangeAlgorithm.ECCPWD, CipherAlgorithm.AES_128_GCM, HashAlgorithm.SHA256, false, false),
    TLS_ECCPWD_WITH_AES_256_GCM_SHA384(49329, CipherType.AEAD, KeyExchangeAlgorithm.ECCPWD, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_ECCPWD_WITH_AES_128_CCM_SHA256(49330, CipherType.AEAD, KeyExchangeAlgorithm.ECCPWD, CipherAlgorithm.AES_128_CCM, HashAlgorithm.SHA256, false, false),
    TLS_ECCPWD_WITH_AES_256_CCM_SHA384(49331, CipherType.AEAD, KeyExchangeAlgorithm.ECCPWD, CipherAlgorithm.AES_256_CCM, HashAlgorithm.SHA384, false, false),
    UNOFFICIAL_TLS_RSA_WITH_CHACHA20_POLY1305(52242, CipherType.AEAD, KeyExchangeAlgorithm.RSA, CipherAlgorithm.UNOFFICIAL_CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    UNOFFICIAL_TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256(52243, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.UNOFFICIAL_CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    UNOFFICIAL_TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256(52244, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.UNOFFICIAL_CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    UNOFFICIAL_TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256(52245, CipherType.AEAD, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.UNOFFICIAL_CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    UNOFFICIAL_TLS_DHE_PSK_WITH_CHACHA20_POLY1305_OLD(52246, CipherType.AEAD, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.UNOFFICIAL_CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    UNOFFICIAL_TLS_PSK_WITH_CHACHA20_POLY1305_OLD(52247, CipherType.AEAD, KeyExchangeAlgorithm.PSK, CipherAlgorithm.UNOFFICIAL_CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    UNOFFICIAL_TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_OLD(52248, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.UNOFFICIAL_CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    UNOFFICIAL_TLS_RSA_PSK_WITH_CHACHA20_POLY1305_OLD(52249, CipherType.AEAD, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.UNOFFICIAL_CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256(52392, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_RSA, CipherAlgorithm.CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256(52393, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_ECDSA, CipherAlgorithm.CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256(52394, CipherType.AEAD, KeyExchangeAlgorithm.DHE_RSA, CipherAlgorithm.CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    TLS_PSK_WITH_CHACHA20_POLY1305_SHA256(52395, CipherType.AEAD, KeyExchangeAlgorithm.PSK, CipherAlgorithm.CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256(52396, CipherType.AEAD, KeyExchangeAlgorithm.ECDHE_PSK, CipherAlgorithm.CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256(52397, CipherType.AEAD, KeyExchangeAlgorithm.DHE_PSK, CipherAlgorithm.CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256(52398, CipherType.AEAD, KeyExchangeAlgorithm.RSA_PSK, CipherAlgorithm.CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    TLS_CECPQ1_RSA_WITH_CHACHA20_POLY1305_SHA256(5815, CipherType.AEAD, KeyExchangeAlgorithm.CECPQ1_RSA, CipherAlgorithm.CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    TLS_CECPQ1_ECDSA_WITH_CHACHA20_POLY1305_SHA256(5816, CipherType.AEAD, KeyExchangeAlgorithm.CECPQ1_ECDSA, CipherAlgorithm.CHACHA20_POLY1305, HashAlgorithm.SHA256, false, false),
    TLS_CECPQ1_RSA_WITH_AES_256_GCM_SHA384(5817, CipherType.AEAD, KeyExchangeAlgorithm.CECPQ1_RSA, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_CECPQ1_ECDSA_WITH_AES_256_GCM_SHA384(5818, CipherType.AEAD, KeyExchangeAlgorithm.CECPQ1_ECDSA, CipherAlgorithm.AES_256_GCM, HashAlgorithm.SHA384, false, false),
    TLS_RSA_WITH_RABBIT_CBC_SHA(253, CipherType.BLOCK, KeyExchangeAlgorithm.RSA, CipherAlgorithm.RABBIT_CBC, HashAlgorithm.SHA1, false, false),
    GREASE_00(2570, true),
    GREASE_01(6682, true),
    GREASE_02(10794, true),
    GREASE_03(14906, true),
    GREASE_04(19018, true),
    GREASE_05(23130, true),
    GREASE_06(27242, true),
    GREASE_07(31354, true),
    GREASE_08(35466, true),
    GREASE_09(39578, true),
    GREASE_10(43690, true),
    GREASE_11(47802, true),
    GREASE_12(51914, true),
    GREASE_13(56026, true),
    GREASE_14(60138, true),
    GREASE_15(64250, true),
    TLS_GOSTR341112_256_WITH_28147_CNT_IMIT(65413, CipherType.STREAM, KeyExchangeAlgorithm.GOSTR341112_256, CipherAlgorithm.GOST_28147_CNT_IMIT, HashAlgorithm.GOST_R3411_12, false, false),
    TLS_GOSTR341112_256_WITH_NULL_GOSTR3411(65415, CipherType.STREAM, KeyExchangeAlgorithm.GOSTR341112_256, CipherAlgorithm.NULL, HashAlgorithm.GOST_R3411_12, false, false);

    private int value;
    private static final Map<Integer, CipherSuite> MAP;
    private final CipherType cipherType;
    private final CipherAlgorithm cipherAlgorithm;
    private final KeyExchangeAlgorithm keyExchangeAlgorithm;
    private final HashAlgorithm hashAlgorithm;
    private final boolean grease;
    private final boolean tls13;
    private final boolean export;
    private boolean isRealCipherSuite;
    public static final Set<CipherSuite> SSL3_SUPPORTED_CIPHERSUITES;

    private CipherSuite(int value, CipherType cipherType, KeyExchangeAlgorithm keyExchangeAlgorithm, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, boolean isExport, boolean isTLS13) {
        this.value = value;
        this.grease = false;
        this.isRealCipherSuite = true;
        this.export = isExport;
        this.cipherType = cipherType;
        this.cipherAlgorithm = cipherAlgorithm;
        this.keyExchangeAlgorithm = keyExchangeAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.tls13 = isTLS13;
    }

    private CipherSuite(int value, boolean isGrease) {
        this.value = value;
        this.grease = isGrease;
        this.cipherAlgorithm = null;
        this.keyExchangeAlgorithm = null;
        this.hashAlgorithm = null;
        this.cipherType = null;
        this.isRealCipherSuite = false;
        this.export = false;
        this.tls13 = true;
    }

    private static int valueToInt(byte[] value) {
        if (value.length >= 2) {
            return (value[0] & 0xFF) << 8 | value[1] & 0xFF;
        }
        if (value.length == 1) {
            return value[0];
        }
        return 0;
    }

    public static List<CipherSuite> getCipherSuites(byte[] values) {
        LinkedList<CipherSuite> cipherSuites = new LinkedList<CipherSuite>();
        if (values.length % 2 != 0) {
            throw new UnknownCipherSuiteException("Last CipherSuit are unknown!");
        }
        for (int pointer = 0; pointer < values.length; pointer += 2) {
            byte[] suite = new byte[]{values[pointer], values[pointer + 1]};
            cipherSuites.add(CipherSuite.getCipherSuite(suite));
        }
        return cipherSuites;
    }

    public boolean isRealCipherSuite() {
        return this.isRealCipherSuite;
    }

    public static CipherSuite getCipherSuite(byte[] value) {
        return CipherSuite.getCipherSuite(CipherSuite.valueToInt(value));
    }

    public static CipherSuite getCipherSuite(int value) {
        CipherSuite cs = MAP.get(value);
        return cs;
    }

    public int getValue() {
        return this.value;
    }

    public byte[] getByteValue() {
        return DataConverter.intToBytes((int)this.value, (int)2);
    }

    public boolean isEphemeral() {
        return this.isTls13() || this.keyExchangeAlgorithm != null && (this.keyExchangeAlgorithm.isKeyExchangeEphemeral() || this.isPWD());
    }

    public boolean isPskOrDhPsk() {
        if (!this.name().contains("RSA")) {
            return this.keyExchangeAlgorithm != null && this.keyExchangeAlgorithm.isPsk();
        }
        return false;
    }

    public boolean isPsk() {
        return this.keyExchangeAlgorithm != null && this.keyExchangeAlgorithm.isPsk();
    }

    public boolean isSrp() {
        return this.keyExchangeAlgorithm != null && this.keyExchangeAlgorithm.isSrp();
    }

    public boolean isExport() {
        return this.export;
    }

    public boolean isGrease() {
        return this.grease;
    }

    public boolean isExportSymmetricCipher() {
        return this.getCipherAlgorithm().getExportFinalKeySize() != null;
    }

    public boolean isCBC() {
        return this.name().contains("_CBC");
    }

    public Boolean isUsingPadding(ProtocolVersion protocolVersion) {
        switch (this.cipherType) {
            case STREAM: {
                return false;
            }
            case BLOCK: {
                return true;
            }
            case AEAD: {
                return protocolVersion == ProtocolVersion.TLS13;
            }
        }
        throw new UnsupportedOperationException("CipherType " + String.valueOf((Object)this.cipherType) + " is not supported");
    }

    public boolean isUsingMac() {
        if (this.name().contains("NULL")) {
            String[] hashFunctionNames;
            String cipher = this.toString();
            if (cipher.endsWith("NULL")) {
                return false;
            }
            for (String hashFunction : hashFunctionNames = new String[]{"MD5", "SHA", "SHA256", "SHA384", "SHA512", "IMIT", "GOSTR3411"}) {
                if (!cipher.endsWith(hashFunction)) continue;
                return true;
            }
            return false;
        }
        return this.name().contains("_CBC") || this.name().contains("RC4") || this.name().contains("CNT");
    }

    public boolean isSCSV() {
        return !this.isRealCipherSuite && !this.isGrease();
    }

    public boolean isGCM() {
        return this.name().contains("_GCM");
    }

    public boolean isCCM() {
        return this.name().contains("_CCM");
    }

    public boolean isCCM_8() {
        return this.name().contains("_CCM_8");
    }

    public boolean isOCB() {
        return this.name().contains("_OCB");
    }

    public boolean isStreamCipherWithIV() {
        return this.name().contains("28147_CNT");
    }

    public boolean isAEAD() {
        return this.isCCM() || this.isChachaPoly() || this.isGCM() || this.isOCB();
    }

    public boolean usesSHA384() {
        return this.name().endsWith("SHA384");
    }

    public boolean usesGOSTR3411() {
        return this.name().startsWith("TLS_GOSTR3410");
    }

    public boolean usesGOSTR34112012() {
        return this.name().startsWith("TLS_GOSTR3411");
    }

    public boolean usesStrictExplicitIv() {
        return this.name().contains("CHACHA20_POLY1305");
    }

    public boolean usesDH() {
        return this.name().contains("_DH");
    }

    public boolean isSupportedInProtocol(ProtocolVersion version) {
        if (version == ProtocolVersion.SSL3) {
            return SSL3_SUPPORTED_CIPHERSUITES.contains((Object)this);
        }
        if (this.isTls13()) {
            return version == ProtocolVersion.TLS13;
        }
        if (this.isGCM()) {
            return version == ProtocolVersion.TLS12 || version == ProtocolVersion.DTLS12 || version.is13();
        }
        if (this.name().endsWith("256") || this.name().endsWith("384") || this.isCCM() || this.isCCM_8()) {
            return version == ProtocolVersion.TLS12 || version == ProtocolVersion.DTLS12;
        }
        if (this.name().contains("IDEA") || this.name().contains("_DES") || this.isExportSymmetricCipher()) {
            return version != ProtocolVersion.TLS12 && version != ProtocolVersion.DTLS12;
        }
        return true;
    }

    public static List<CipherSuite> getImplemented() {
        LinkedList<CipherSuite> list = new LinkedList<CipherSuite>();
        list.add(TLS_RSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_RSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_RSA_WITH_NULL_MD5);
        list.add(TLS_RSA_WITH_NULL_SHA);
        list.add(TLS_RSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_RSA_WITH_AES_256_CBC_SHA256);
        list.add(TLS_RSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_RSA_WITH_CAMELLIA_128_CBC_SHA);
        list.add(TLS_RSA_WITH_CAMELLIA_256_CBC_SHA);
        list.add(TLS_RSA_WITH_IDEA_CBC_SHA);
        list.add(TLS_RSA_WITH_DES_CBC_SHA);
        list.add(TLS_RSA_WITH_SEED_CBC_SHA);
        list.add(TLS_RSA_WITH_RC4_128_MD5);
        list.add(TLS_RSA_WITH_RC4_128_SHA);
        list.add(TLS_RSA_WITH_AES_128_CCM);
        list.add(TLS_RSA_WITH_AES_256_CCM);
        list.add(TLS_RSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_RSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DH_anon_EXPORT_WITH_RC4_40_MD5);
        list.add(TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA);
        list.add(TLS_DH_anon_WITH_RC4_128_MD5);
        list.add(TLS_DH_anon_WITH_DES_CBC_SHA);
        list.add(TLS_DH_anon_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_AES_128_CBC_SHA);
        list.add(TLS_DH_RSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_AES_128_CBC_SHA);
        list.add(TLS_DHE_RSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_DH_anon_WITH_AES_128_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_AES_256_CBC_SHA);
        list.add(TLS_DH_RSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_AES_256_CBC_SHA);
        list.add(TLS_DHE_RSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_DH_anon_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_ECDH_RSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_ECDH_RSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384);
        list.add(TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384);
        list.add(TLS_DH_RSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DH_RSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_DH_DSS_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DH_anon_WITH_AES_128_GCM_SHA256);
        list.add(TLS_DH_anon_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DHE_RSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_DHE_RSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DHE_RSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_DHE_RSA_WITH_AES_256_CBC_SHA256);
        list.add(TLS_DH_anon_WITH_AES_128_CBC_SHA256);
        list.add(TLS_DH_anon_WITH_AES_256_CBC_SHA256);
        list.add(TLS_DHE_RSA_WITH_DES_CBC_SHA);
        list.add(TLS_DHE_RSA_WITH_AES_128_CCM);
        list.add(TLS_DHE_RSA_WITH_AES_256_CCM);
        list.add(TLS_DHE_RSA_WITH_SEED_CBC_SHA);
        list.add(TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA);
        list.add(TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_AES_128_GCM_SHA256);
        list.add(TLS_DHE_DSS_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DHE_DSS_WITH_RC4_128_SHA);
        list.add(TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_ECDHE_RSA_WITH_RC4_128_SHA);
        list.add(TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_128_CCM);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_256_CCM);
        list.add(TLS_AES_128_GCM_SHA256);
        list.add(TLS_AES_256_GCM_SHA384);
        list.add(TLS_CHACHA20_POLY1305_SHA256);
        list.add(TLS_AES_128_CCM_SHA256);
        list.add(TLS_AES_128_CCM_8_SHA256);
        list.add(TLS_PSK_WITH_AES_128_CBC_SHA);
        list.add(TLS_PSK_DHE_WITH_AES_128_CCM_8);
        list.add(TLS_PSK_DHE_WITH_AES_256_CCM_8);
        list.add(TLS_PSK_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_PSK_WITH_AES_128_CBC_SHA256);
        list.add(TLS_PSK_WITH_AES_128_CCM);
        list.add(TLS_PSK_WITH_AES_128_CCM_8);
        list.add(TLS_PSK_WITH_AES_128_GCM_SHA256);
        list.add(TLS_PSK_WITH_AES_256_CBC_SHA);
        list.add(TLS_PSK_WITH_AES_256_CBC_SHA384);
        list.add(TLS_PSK_WITH_AES_256_CCM);
        list.add(TLS_PSK_WITH_AES_256_CCM_8);
        list.add(TLS_PSK_WITH_AES_256_GCM_SHA384);
        list.add(TLS_PSK_WITH_RC4_128_SHA);
        list.add(TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DHE_PSK_WITH_AES_128_CBC_SHA);
        list.add(TLS_DHE_PSK_WITH_AES_128_CCM);
        list.add(TLS_DHE_PSK_WITH_AES_128_GCM_SHA256);
        list.add(TLS_DHE_PSK_WITH_AES_256_CBC_SHA);
        list.add(TLS_DHE_PSK_WITH_AES_256_CBC_SHA384);
        list.add(TLS_DHE_PSK_WITH_AES_256_CCM);
        list.add(TLS_DHE_PSK_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DHE_PSK_WITH_RC4_128_SHA);
        list.add(TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384);
        list.add(TLS_ECDHE_PSK_WITH_RC4_128_SHA);
        list.add(TLS_DH_RSA_WITH_DES_CBC_SHA);
        list.add(TLS_DH_RSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_ECDSA_WITH_RC4_128_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_ECDSA_WITH_DES_CBC_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_AES_256_CBC_SHA256);
        list.add(TLS_DH_RSA_WITH_AES_256_CBC_SHA256);
        list.add(TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA);
        list.add(TLS_RSA_PSK_WITH_RC4_128_SHA);
        list.add(TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_RSA_PSK_WITH_AES_128_CBC_SHA);
        list.add(TLS_RSA_PSK_WITH_AES_256_CBC_SHA);
        list.add(TLS_DH_RSA_WITH_SEED_CBC_SHA);
        list.add(TLS_RSA_PSK_WITH_AES_128_GCM_SHA256);
        list.add(TLS_RSA_PSK_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DHE_PSK_WITH_AES_128_CBC_SHA256);
        list.add(TLS_RSA_PSK_WITH_AES_128_CBC_SHA256);
        list.add(TLS_RSA_PSK_WITH_AES_256_CBC_SHA384);
        list.add(TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256);
        list.add(TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256);
        list.add(TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_RC4_128_SHA);
        list.add(TLS_ECDHE_ECDSA_WITH_RC4_128_SHA);
        list.add(TLS_ECDH_RSA_WITH_RC4_128_SHA);
        list.add(TLS_ECDH_anon_WITH_NULL_SHA);
        list.add(TLS_SRP_SHA_WITH_AES_128_CBC_SHA);
        list.add(TLS_SRP_SHA_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384);
        list.add(TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384);
        list.add(TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256);
        list.add(TLS_RSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_RSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_RSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_RSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_PSK_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_PSK_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_PSK_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_PSK_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_PSK_WITH_NULL_SHA);
        list.add(TLS_DHE_PSK_WITH_NULL_SHA);
        list.add(TLS_RSA_PSK_WITH_NULL_SHA);
        list.add(TLS_RSA_WITH_NULL_SHA256);
        list.add(UNOFFICIAL_TLS_ECDH_ECDSA_WITH_NULL_SHA);
        list.add(TLS_PSK_WITH_NULL_SHA256);
        list.add(TLS_PSK_WITH_NULL_SHA384);
        list.add(TLS_DHE_PSK_WITH_NULL_SHA256);
        list.add(TLS_DHE_PSK_WITH_NULL_SHA384);
        list.add(TLS_RSA_PSK_WITH_NULL_SHA256);
        list.add(TLS_RSA_PSK_WITH_NULL_SHA384);
        list.add(TLS_ECDH_ECDSA_WITH_NULL_SHA);
        list.add(TLS_ECDHE_ECDSA_WITH_NULL_SHA);
        list.add(TLS_ECDH_RSA_WITH_NULL_SHA);
        list.add(TLS_ECDHE_RSA_WITH_NULL_SHA);
        list.add(TLS_ECDHE_PSK_WITH_NULL_SHA);
        list.add(TLS_ECDHE_PSK_WITH_NULL_SHA256);
        list.add(TLS_ECDHE_PSK_WITH_NULL_SHA384);
        list.add(TLS_DH_DSS_WITH_DES_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_DES_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_AES_128_CBC_SHA256);
        list.add(TLS_DHE_DSS_WITH_AES_128_CBC_SHA256);
        list.add(TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA);
        list.add(TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_anon_WITH_NULL_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_anon_WITH_RC4_128_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_anon_WITH_DES_CBC_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_AES_256_CBC_SHA256);
        list.add(TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA);
        list.add(TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_SEED_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_SEED_CBC_SHA);
        list.add(TLS_DH_anon_WITH_SEED_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_AES_128_GCM_SHA256);
        list.add(TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256);
        list.add(TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256);
        list.add(TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256);
        list.add(TLS_ECDH_anon_WITH_RC4_128_SHA);
        list.add(TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_ECDH_anon_WITH_AES_128_CBC_SHA);
        list.add(TLS_ECDH_anon_WITH_AES_256_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_DH_anon_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_DH_anon_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_DH_anon_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_DH_anon_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_GOSTR341001_WITH_28147_CNT_IMIT);
        list.add(TLS_GOSTR341001_WITH_NULL_GOSTR3411);
        list.add(TLS_GOSTR341112_256_WITH_28147_CNT_IMIT);
        list.add(TLS_GOSTR341112_256_WITH_NULL_GOSTR3411);
        list.add(TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256);
        list.add(TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256);
        list.add(TLS_ECCPWD_WITH_AES_128_GCM_SHA256);
        list.add(TLS_ECCPWD_WITH_AES_256_GCM_SHA384);
        list.add(TLS_ECCPWD_WITH_AES_128_CCM_SHA256);
        list.add(TLS_ECCPWD_WITH_AES_256_CCM_SHA384);
        list.add(TLS_RSA_WITH_AES_128_CCM_8);
        list.add(TLS_RSA_WITH_AES_256_CCM_8);
        list.add(TLS_DHE_RSA_WITH_AES_128_CCM_8);
        list.add(TLS_DHE_RSA_WITH_AES_256_CCM_8);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8);
        list.add(TLS_PSK_WITH_CHACHA20_POLY1305_SHA256);
        list.add(TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256);
        list.add(TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256);
        list.add(TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256);
        list.add(UNOFFICIAL_TLS_RSA_WITH_CHACHA20_POLY1305);
        list.add(UNOFFICIAL_TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256);
        list.add(UNOFFICIAL_TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256);
        list.add(UNOFFICIAL_TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256);
        list.add(UNOFFICIAL_TLS_DHE_PSK_WITH_CHACHA20_POLY1305_OLD);
        list.add(UNOFFICIAL_TLS_PSK_WITH_CHACHA20_POLY1305_OLD);
        list.add(UNOFFICIAL_TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_OLD);
        list.add(UNOFFICIAL_TLS_RSA_PSK_WITH_CHACHA20_POLY1305_OLD);
        list.add(TLS_RSA_EXPORT_WITH_RC4_40_MD5);
        list.add(TLS_RSA_EXPORT_WITH_DES40_CBC_SHA);
        list.add(TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5);
        list.add(TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA);
        list.add(TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA);
        list.add(TLS_SM4_GCM_SM3);
        list.add(TLS_SM4_CCM_SM3);
        list.add(TLS_NULL_WITH_NULL_NULL);
        return list;
    }

    public static List<CipherSuite> getEsniImplemented() {
        LinkedList<CipherSuite> list = new LinkedList<CipherSuite>();
        list.add(TLS_AES_128_GCM_SHA256);
        list.add(TLS_AES_256_GCM_SHA384);
        list.add(TLS_CHACHA20_POLY1305_SHA256);
        list.add(TLS_AES_128_CCM_SHA256);
        list.add(TLS_AES_128_CCM_8_SHA256);
        return list;
    }

    public static List<CipherSuite> getAllCipherSuites() {
        LinkedList<CipherSuite> list = new LinkedList<CipherSuite>();
        list.addAll(Arrays.asList(CipherSuite.values()));
        return list;
    }

    public static List<CipherSuite> getTls13CipherSuites() {
        return CipherSuite.getAllCipherSuites().stream().filter(CipherSuite::isTls13).collect(Collectors.toList());
    }

    public static List<CipherSuite> getImplementedTls13CipherSuites() {
        return CipherSuite.getImplemented().stream().filter(CipherSuite::isTls13).collect(Collectors.toList());
    }

    public static List<CipherSuite> getNotImplemented() {
        LinkedList<CipherSuite> notImplemented = new LinkedList<CipherSuite>();
        for (CipherSuite suite : CipherSuite.values()) {
            if (CipherSuite.getImplemented().contains((Object)suite)) continue;
            notImplemented.add(suite);
        }
        return notImplemented;
    }

    public boolean isTls13() {
        return this.tls13;
    }

    public CipherType getCipherType() {
        return this.cipherType;
    }

    public CipherAlgorithm getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public KeyExchangeAlgorithm getKeyExchangeAlgorithm() {
        return this.keyExchangeAlgorithm;
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public boolean isImplemented() {
        return CipherSuite.getImplemented().contains((Object)this);
    }

    public boolean isSHA1() {
        return this.hashAlgorithm == HashAlgorithm.SHA1;
    }

    public boolean isSHA256() {
        return this.hashAlgorithm == HashAlgorithm.SHA256;
    }

    public boolean isSHA384() {
        return this.hashAlgorithm == HashAlgorithm.SHA384;
    }

    public boolean isSHA512() {
        return this.hashAlgorithm == HashAlgorithm.SHA512;
    }

    public boolean isChachaPoly() {
        return this.cipherAlgorithm == CipherAlgorithm.CHACHA20_POLY1305;
    }

    public boolean isECDSA() {
        return this.keyExchangeAlgorithm != null && this.keyExchangeAlgorithm.isEcdsa();
    }

    public boolean isAnon() {
        return this.keyExchangeAlgorithm != null && this.keyExchangeAlgorithm.isAnon();
    }

    public boolean isNull() {
        return this.name().toLowerCase().contains("null");
    }

    public boolean isPWD() {
        return this.keyExchangeAlgorithm == KeyExchangeAlgorithm.ECCPWD;
    }

    public boolean isDSS() {
        return this.keyExchangeAlgorithm != null && this.keyExchangeAlgorithm.isDss();
    }

    public boolean isGOST() {
        return this.keyExchangeAlgorithm != null && this.keyExchangeAlgorithm.isGost();
    }

    public boolean isSM() {
        return this.name().contains("SM");
    }

    public boolean isWeak() {
        return this.isExport() || this.isExportSymmetricCipher() || this.isAnon() || this.isNull();
    }

    public boolean requiresServerCertificateMessage() {
        return !this.isSrp() && !this.isPskOrDhPsk() && !this.isAnon() && !this.isPWD();
    }

    static {
        MAP = new HashMap<Integer, CipherSuite>();
        for (CipherSuite c : CipherSuite.values()) {
            MAP.put(c.value, c);
        }
        SSL3_SUPPORTED_CIPHERSUITES = Collections.unmodifiableSet(new HashSet<CipherSuite>(Arrays.asList(TLS_NULL_WITH_NULL_NULL, TLS_RSA_WITH_NULL_MD5, TLS_RSA_WITH_NULL_SHA, TLS_RSA_EXPORT_WITH_RC4_40_MD5, TLS_RSA_WITH_RC4_128_MD5, TLS_RSA_WITH_RC4_128_SHA, TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5, TLS_RSA_WITH_IDEA_CBC_SHA, TLS_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_RSA_WITH_DES_CBC_SHA, TLS_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA, TLS_DH_DSS_WITH_DES_CBC_SHA, TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA, TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_DH_RSA_WITH_DES_CBC_SHA, TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA, TLS_DHE_DSS_WITH_DES_CBC_SHA, TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA, TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_DHE_RSA_WITH_DES_CBC_SHA, TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DH_anon_EXPORT_WITH_RC4_40_MD5, TLS_DH_anon_WITH_RC4_128_MD5, TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA, TLS_DH_anon_WITH_DES_CBC_SHA, TLS_DH_anon_WITH_3DES_EDE_CBC_SHA)));
    }
}

