/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.protocol.constants.HashAlgorithm;
import de.rub.nds.protocol.constants.MacAlgorithm;
import de.rub.nds.protocol.constants.SignatureAlgorithm;
import de.rub.nds.tlsattacker.core.constants.BulkCipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CipherType;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgorithmResolver {
    private static final Logger LOGGER = LogManager.getLogger();

    public static PRFAlgorithm getPRFAlgorithm(ProtocolVersion protocolVersion, CipherSuite cipherSuite) {
        if (protocolVersion == ProtocolVersion.SSL3 || protocolVersion == ProtocolVersion.SSL2) {
            return null;
        }
        PRFAlgorithm result = cipherSuite.usesGOSTR3411() ? PRFAlgorithm.TLS_PRF_GOSTR3411 : (cipherSuite.usesGOSTR34112012() ? PRFAlgorithm.TLS_PRF_GOSTR3411_2012_256 : (protocolVersion == ProtocolVersion.TLS10 || protocolVersion == ProtocolVersion.TLS11 || protocolVersion == ProtocolVersion.DTLS10 ? PRFAlgorithm.TLS_PRF_LEGACY : (cipherSuite.usesSHA384() ? PRFAlgorithm.TLS_PRF_SHA384 : PRFAlgorithm.TLS_PRF_SHA256)));
        LOGGER.debug("Using the following PRF Algorithm: {}", (Object)result);
        return result;
    }

    public static DigestAlgorithm getDigestAlgorithm(ProtocolVersion protocolVersion, CipherSuite cipherSuite) {
        if (protocolVersion == ProtocolVersion.SSL3 || protocolVersion == ProtocolVersion.SSL2) {
            throw new UnsupportedOperationException("SSL3 and SSL2 PRF currently not supported");
        }
        DigestAlgorithm result = cipherSuite.usesGOSTR3411() ? DigestAlgorithm.GOSTR3411 : (cipherSuite.usesGOSTR34112012() ? DigestAlgorithm.GOSTR34112012_256 : (protocolVersion == ProtocolVersion.TLS10 || protocolVersion == ProtocolVersion.TLS11 || protocolVersion == ProtocolVersion.DTLS10 ? DigestAlgorithm.LEGACY : (cipherSuite.isSM() ? DigestAlgorithm.SM3 : (cipherSuite.usesSHA384() ? DigestAlgorithm.SHA384 : DigestAlgorithm.SHA256))));
        LOGGER.debug("Using the following Digest Algorithm: {}", (Object)result);
        return result;
    }

    @Deprecated
    public static KeyExchangeAlgorithm getKeyExchangeAlgorithm(CipherSuite cipherSuite) {
        return cipherSuite.getKeyExchangeAlgorithm();
    }

    public static X509PublicKeyType[] getSuitableLeafCertificateKeyType(CipherSuite suite) {
        KeyExchangeAlgorithm keyExchangeAlgorithm = suite.getKeyExchangeAlgorithm();
        if (keyExchangeAlgorithm == null) {
            return X509PublicKeyType.values();
        }
        switch (keyExchangeAlgorithm) {
            case DHE_RSA: 
            case ECDHE_RSA: 
            case RSA: 
            case RSA_EXPORT: 
            case SRP_SHA_RSA: 
            case RSA_PSK: {
                return new X509PublicKeyType[]{X509PublicKeyType.RSA};
            }
            case DH_RSA: 
            case DH_DSS: {
                return new X509PublicKeyType[]{X509PublicKeyType.DH};
            }
            case ECDH_ECDSA: 
            case ECDH_RSA: 
            case ECDHE_ECDSA: 
            case ECMQV_ECDSA: 
            case CECPQ1_ECDSA: {
                return new X509PublicKeyType[]{X509PublicKeyType.ECDH_ECDSA};
            }
            case DHE_DSS: 
            case SRP_SHA_DSS: {
                return new X509PublicKeyType[]{X509PublicKeyType.DSA};
            }
            case VKO_GOST01: {
                return new X509PublicKeyType[]{X509PublicKeyType.GOST_R3411_2001};
            }
            case VKO_GOST12: {
                return new X509PublicKeyType[]{X509PublicKeyType.GOST_R3411_94};
            }
            case DHE_PSK: 
            case DH_ANON: 
            case ECCPWD: 
            case ECDHE_PSK: 
            case ECDH_ANON: 
            case NULL: 
            case PSK: 
            case SRP_SHA: 
            case KRB5: {
                return new X509PublicKeyType[0];
            }
            case ECDH_ECNRA: 
            case ECMQV_ECNRA: {
                throw new UnsupportedOperationException("Not Implemented");
            }
            case FORTEZZA_KEA: {
                return new X509PublicKeyType[]{X509PublicKeyType.KEA};
            }
        }
        throw new UnsupportedOperationException("Unsupported KeyExchange Algorithm: " + String.valueOf((Object)keyExchangeAlgorithm));
    }

    @Deprecated
    public static CipherAlgorithm getCipher(CipherSuite cipherSuite) {
        return cipherSuite.getCipherAlgorithm();
    }

    @Deprecated
    public static BulkCipherAlgorithm getBulkCipherAlgorithm(CipherSuite cipherSuite) {
        return BulkCipherAlgorithm.getBulkCipherAlgorithm(cipherSuite);
    }

    @Deprecated
    public static CipherType getCipherType(CipherSuite cipherSuite) {
        return cipherSuite.getCipherType();
    }

    public static MacAlgorithm getMacAlgorithm(ProtocolVersion protocolVersion, CipherSuite cipherSuite) {
        if (cipherSuite.getCipherType() == CipherType.AEAD) {
            return MacAlgorithm.NONE;
        }
        HashAlgorithm hashAlgorithm = cipherSuite.getHashAlgorithm();
        if (cipherSuite.name().contains("IMIT")) {
            return MacAlgorithm.IMIT_GOST28147;
        }
        if (hashAlgorithm == HashAlgorithm.MD5) {
            if (protocolVersion == ProtocolVersion.SSL3 || protocolVersion == ProtocolVersion.SSL2) {
                return MacAlgorithm.SSLMAC_MD5;
            }
            return MacAlgorithm.HMAC_MD5;
        }
        if (hashAlgorithm == HashAlgorithm.SHA1) {
            if (protocolVersion == ProtocolVersion.SSL3 || protocolVersion == ProtocolVersion.SSL2) {
                return MacAlgorithm.SSLMAC_SHA1;
            }
            return MacAlgorithm.HMAC_SHA1;
        }
        if (hashAlgorithm == HashAlgorithm.SHA256) {
            return MacAlgorithm.HMAC_SHA256;
        }
        if (hashAlgorithm == HashAlgorithm.SHA384) {
            return MacAlgorithm.HMAC_SHA384;
        }
        if (hashAlgorithm == HashAlgorithm.SHA512) {
            return MacAlgorithm.HMAC_SHA512;
        }
        if (hashAlgorithm == HashAlgorithm.SM3) {
            return MacAlgorithm.HMAC_SM3;
        }
        if (hashAlgorithm == HashAlgorithm.GOST_R3411_94) {
            return MacAlgorithm.HMAC_GOSTR3411;
        }
        if (hashAlgorithm == HashAlgorithm.GOST_R3411_12) {
            return MacAlgorithm.HMAC_GOSTR3411_2012_256;
        }
        if (hashAlgorithm == HashAlgorithm.NONE) {
            return MacAlgorithm.NONE;
        }
        if (!cipherSuite.isRealCipherSuite()) {
            LOGGER.warn("Trying to retrieve MAC algorithm of a non-real cipher suite: {}", (Object)cipherSuite);
        }
        return MacAlgorithm.NONE;
    }

    public static HKDFAlgorithm getHKDFAlgorithm(CipherSuite cipherSuite) {
        HashAlgorithm hashAlgorithm = cipherSuite.getHashAlgorithm();
        if (hashAlgorithm == HashAlgorithm.SHA256) {
            return HKDFAlgorithm.TLS_HKDF_SHA256;
        }
        if (hashAlgorithm == HashAlgorithm.SHA384) {
            return HKDFAlgorithm.TLS_HKDF_SHA384;
        }
        if (hashAlgorithm == HashAlgorithm.SM3) {
            return HKDFAlgorithm.TLS_HKDF_SM3;
        }
        LOGGER.warn("The HKDF algorithm for cipher suite {} is not supported yet or is undefined. Using \"TLS_HKDF_SHA256\"", (Object)cipherSuite);
        return HKDFAlgorithm.TLS_HKDF_SHA256;
    }

    public static SignatureAlgorithm getRequiredSignatureAlgorithm(CipherSuite cipherSuite) {
        KeyExchangeAlgorithm keyExchangeAlgorithm = AlgorithmResolver.getKeyExchangeAlgorithm(cipherSuite);
        if (keyExchangeAlgorithm == null) {
            return null;
        }
        switch (keyExchangeAlgorithm) {
            case DHE_RSA: 
            case ECDHE_RSA: 
            case RSA: 
            case RSA_EXPORT: 
            case SRP_SHA_RSA: 
            case RSA_PSK: 
            case DH_RSA: 
            case ECDH_RSA: {
                return SignatureAlgorithm.RSA_PKCS1;
            }
            case ECDH_ECDSA: 
            case ECDHE_ECDSA: 
            case ECMQV_ECDSA: 
            case CECPQ1_ECDSA: {
                return SignatureAlgorithm.ECDSA;
            }
            case DH_DSS: 
            case DHE_DSS: 
            case SRP_SHA_DSS: {
                return SignatureAlgorithm.DSA;
            }
            case VKO_GOST01: {
                return SignatureAlgorithm.GOSTR34102001;
            }
            case VKO_GOST12: {
                return SignatureAlgorithm.GOSTR34102012_256;
            }
        }
        return null;
    }

    private AlgorithmResolver() {
    }
}

