/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.HashMap;
import java.util.Map;

public enum AlertDescription {
    CLOSE_NOTIFY(0),
    UNEXPECTED_MESSAGE(10),
    BAD_RECORD_MAC(20),
    DECRYPTION_FAILED_RESERVED(21),
    RECORD_OVERFLOW(22),
    DECOMPRESSION_FAILURE(30),
    HANDSHAKE_FAILURE(40),
    NO_CERTIFICATE_RESERVED(41),
    BAD_CERTIFICATE(42),
    UNSUPPORTED_CERTIFICATE(43),
    CERTIFICATE_REVOKED(44),
    CERTIFICATE_EXPIRED(45),
    CERTIFICATE_UNKNOWN(46),
    ILLEGAL_PARAMETER(47),
    UNKNOWN_CA(48),
    ACCESS_DENIED(49),
    DECODE_ERROR(50),
    DECRYPT_ERROR(51),
    EXPORT_RESTRICTION_RESERVED(60),
    PROTOCOL_VERSION(70),
    INSUFFICIENT_SECURITY(71),
    INTERNAL_ERROR(80),
    INAPPROPRIATE_FALLBACK(86),
    USER_CANCELED(90),
    NO_RENEGOTIATION(100),
    MISSING_EXTENSION(109),
    UNSUPPORTED_EXTENSION(110),
    CERTIFICATE_UNOBTAINABLE(111),
    UNRECOGNIZED_NAME(112),
    BAD_CERTIFICATE_STATUS_RESPONSE(113),
    BAD_CERTIFICATE_HASH_VALUE(114),
    UNKNOWN_PSK_IDENTITY(115),
    CERTIFICATE_REQUIRED(116),
    NO_APPLICATION_PROTOCOL(120);

    private byte value;
    private static final Map<Byte, AlertDescription> MAP;

    private AlertDescription(byte value) {
        this.value = value;
    }

    public static AlertDescription getAlertDescription(byte value) {
        return MAP.get(value);
    }

    public byte getValue() {
        return this.value;
    }

    public byte[] getArrayValue() {
        return new byte[]{this.value};
    }

    public String toString() {
        return "AlertDescription{value=" + AlertDescription.getAlertDescription(this.value).name() + "}";
    }

    static {
        MAP = new HashMap<Byte, AlertDescription>();
        for (AlertDescription cm : AlertDescription.values()) {
            MAP.put(cm.value, cm);
        }
    }
}

