/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import java.util.Collections;
import java.util.List;

public class CompressionDelegate
extends Delegate {
    @Parameter(names={"-compression"}, description="TLS compression methods to use, divided by a comma. (currently, only NULL compression is supported)")
    private List<CompressionMethod> compressionMethods;

    public List<CompressionMethod> getCompressionMethods() {
        if (this.compressionMethods == null) {
            return null;
        }
        return Collections.unmodifiableList(this.compressionMethods);
    }

    public void setCompressionMethods(List<CompressionMethod> compressionMethods) {
        this.compressionMethods = compressionMethods;
    }

    @Override
    public void applyDelegate(Config config) {
        if (this.compressionMethods != null) {
            config.setDefaultClientSupportedCompressionMethods(this.compressionMethods);
            config.setDefaultServerSupportedCompressionMethods(this.compressionMethods);
            if (this.compressionMethods.size() > 0) {
                config.setDefaultSelectedCompressionMethod(this.compressionMethods.get(0));
            }
        }
    }
}

