/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.ParametersDelegate;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class TLSDelegateConfig {
    private final List<Delegate> delegateList = new LinkedList<Delegate>();
    @ParametersDelegate
    private final GeneralDelegate generalDelegate;
    @Parameter(names={"-config"}, description="This parameter allows you to specify a default TlsConfig")
    private String defaultConfig = null;

    public TLSDelegateConfig(GeneralDelegate delegate) {
        this.generalDelegate = delegate;
        if (delegate != null) {
            this.delegateList.add(this.generalDelegate);
        }
    }

    public final void addDelegate(Delegate delegate) {
        this.delegateList.add(delegate);
    }

    public <T extends Delegate> T getDelegate(Class<T> delegateClass) {
        for (Delegate delegate : this.getDelegateList()) {
            if (!delegate.getClass().equals(delegateClass)) continue;
            return (T)((Delegate)delegateClass.cast(delegate));
        }
        return null;
    }

    public List<Delegate> getDelegateList() {
        return Collections.unmodifiableList(this.delegateList);
    }

    public GeneralDelegate getGeneralDelegate() {
        return this.generalDelegate;
    }

    public Config createConfig(Config baseConfig) {
        for (Delegate delegate : this.getDelegateList()) {
            delegate.applyDelegate(baseConfig);
        }
        return baseConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Config createConfig() {
        Config config = null;
        if (this.defaultConfig != null) {
            File configFile = new File(this.defaultConfig);
            if (!configFile.exists()) throw new ParameterException("Could not find config file: " + this.defaultConfig);
            config = Config.createConfig(configFile);
            return this.createConfig(config);
        } else {
            config = new Config();
        }
        return this.createConfig(config);
    }

    public final boolean hasDifferentConfig() {
        return this.defaultConfig != null;
    }
}

