/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.string;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.IllegalStringAdapter;
import de.rub.nds.modifiablevariable.util.StringUtil;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Objects;

@XmlRootElement
public class StringPrependValueModification
extends VariableModification<String> {
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    @JsonProperty(required=true)
    private String prependValue;

    private StringPrependValueModification() {
    }

    public StringPrependValueModification(String prependValue) {
        this.prependValue = Objects.requireNonNull(prependValue, "PrependValue must not be null");
    }

    public StringPrependValueModification(StringPrependValueModification other) {
        this.prependValue = other.prependValue;
    }

    public StringPrependValueModification createCopy() {
        return new StringPrependValueModification(this);
    }

    @Override
    protected String modifyImplementationHook(String input) {
        if (input == null) {
            return null;
        }
        return this.prependValue + input;
    }

    public String getPrependValue() {
        return this.prependValue;
    }

    public void setPrependValue(String prependValue) {
        this.prependValue = Objects.requireNonNull(prependValue, "PrependValue must not be null");
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.prependValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringPrependValueModification other = (StringPrependValueModification)obj;
        return Objects.equals(this.prependValue, other.prependValue);
    }

    public String toString() {
        return "StringPrependValueModification{prependValue='" + StringUtil.backslashEscapeString(this.prependValue) + "'}";
    }
}

