/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.string;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

@XmlRootElement
public class StringDeleteModification
extends VariableModification<String> {
    @JsonProperty(required=true)
    private int count;
    @JsonProperty(required=true)
    private int startPosition;

    private StringDeleteModification() {
    }

    public StringDeleteModification(int startPosition, int count) {
        this.startPosition = startPosition;
        this.count = count;
    }

    public StringDeleteModification(StringDeleteModification other) {
        this.count = other.count;
        this.startPosition = other.startPosition;
    }

    public StringDeleteModification createCopy() {
        return new StringDeleteModification(this);
    }

    @Override
    protected String modifyImplementationHook(String input) {
        if (input == null) {
            return null;
        }
        if (input.isEmpty()) {
            return input;
        }
        if (this.count <= 0) {
            return input;
        }
        int deleteStartPosition = this.startPosition < 0 ? Math.max(0, input.length() + this.startPosition) : (this.startPosition >= input.length() ? this.startPosition % input.length() : this.startPosition);
        int deleteEndPosition = Math.min(input.length(), deleteStartPosition + this.count);
        return new StringBuilder(input).delete(deleteStartPosition, deleteEndPosition).toString();
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.count;
        hash = 31 * hash + this.startPosition;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringDeleteModification other = (StringDeleteModification)obj;
        if (this.startPosition != other.startPosition) {
            return false;
        }
        return Objects.equals(this.count, other.count);
    }

    public String toString() {
        return "StringDeleteModification{count=" + this.count + ", startPosition=" + this.startPosition + "}";
    }
}

