/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.singlebyte;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

@XmlRootElement
public class ByteXorModification
extends VariableModification<Byte> {
    @JsonProperty(required=true)
    private byte xor;

    private ByteXorModification() {
    }

    public ByteXorModification(byte xor) {
        this.xor = xor;
    }

    public ByteXorModification(ByteXorModification other) {
        this.xor = other.xor;
    }

    public ByteXorModification createCopy() {
        return new ByteXorModification(this);
    }

    @Override
    protected Byte modifyImplementationHook(Byte input) {
        if (input == null) {
            return null;
        }
        return (byte)(input ^ this.xor);
    }

    public byte getXor() {
        return this.xor;
    }

    public void setXor(byte xor) {
        this.xor = xor;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.xor;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteXorModification other = (ByteXorModification)obj;
        return Objects.equals(this.xor, other.xor);
    }

    public String toString() {
        return "ByteXorModification{xor=" + this.xor + "}";
    }
}

