/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.logging;

import de.rub.nds.modifiablevariable.util.DataConverter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.pattern.RegexReplacement;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="ExtendedPatternLayout", category="Core", elementType="layout", printObject=true)
public final class ExtendedPatternLayout
extends AbstractStringLayout {
    public static final String DEFAULT_CONVERSION_PATTERN = "%m%n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %notEmpty{%x }- %m%n";
    public static final String SIMPLE_CONVERSION_PATTERN = "%d [%t] %p %c - %m%n";
    public static final String KEY = "Converter";
    private final String conversionPattern;
    private final PatternSelector patternSelector;
    private final AbstractStringLayout.Serializer eventSerializer;

    private ExtendedPatternLayout(Configuration config, RegexReplacement replace, String eventPattern, PatternSelector patternSelector, Charset charset, boolean alwaysWriteExceptions, boolean disableAnsi, boolean noConsoleNoAnsi, String headerPattern, String footerPattern, boolean initNewLine, boolean prettyPrinting) {
        super(config, charset, ExtendedPatternLayout.newSerializerBuilder().setConfiguration(config).setReplace(replace).setPatternSelector(patternSelector).setAlwaysWriteExceptions(alwaysWriteExceptions).setDisableAnsi(disableAnsi).setNoConsoleNoAnsi(noConsoleNoAnsi).setPattern(headerPattern).setInitNewLine(initNewLine).setPrettyPrinting(prettyPrinting).build(), ExtendedPatternLayout.newSerializerBuilder().setConfiguration(config).setReplace(replace).setPatternSelector(patternSelector).setAlwaysWriteExceptions(alwaysWriteExceptions).setDisableAnsi(disableAnsi).setNoConsoleNoAnsi(noConsoleNoAnsi).setPattern(footerPattern).setInitNewLine(initNewLine).setPrettyPrinting(prettyPrinting).build());
        this.conversionPattern = eventPattern;
        this.patternSelector = patternSelector;
        this.eventSerializer = ExtendedPatternLayout.newSerializerBuilder().setConfiguration(config).setReplace(replace).setPatternSelector(patternSelector).setAlwaysWriteExceptions(alwaysWriteExceptions).setDisableAnsi(disableAnsi).setNoConsoleNoAnsi(noConsoleNoAnsi).setPattern(eventPattern).setDefaultPattern(DEFAULT_CONVERSION_PATTERN).setInitNewLine(initNewLine).setPrettyPrinting(prettyPrinting).build();
    }

    public static SerializerBuilder newSerializerBuilder() {
        return new SerializerBuilder();
    }

    public boolean requiresLocation() {
        return this.eventSerializer instanceof LocationAware && ((LocationAware)this.eventSerializer).requiresLocation();
    }

    @Deprecated
    public static AbstractStringLayout.Serializer createSerializer(Configuration configuration, RegexReplacement replace, String pattern, String defaultPattern, PatternSelector patternSelector, boolean alwaysWriteExceptions, boolean noConsoleNoAnsi) {
        SerializerBuilder builder = ExtendedPatternLayout.newSerializerBuilder();
        builder.setAlwaysWriteExceptions(alwaysWriteExceptions);
        builder.setConfiguration(configuration);
        builder.setDefaultPattern(defaultPattern);
        builder.setNoConsoleNoAnsi(noConsoleNoAnsi);
        builder.setPattern(pattern);
        builder.setPatternSelector(patternSelector);
        builder.setReplace(replace);
        return builder.build();
    }

    public String getConversionPattern() {
        return this.conversionPattern;
    }

    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("structured", "false");
        result.put("formatType", "conversion");
        result.put("format", this.conversionPattern);
        return result;
    }

    public String toSerializable(LogEvent event) {
        return this.eventSerializer.toSerializable(event);
    }

    public void serialize(LogEvent event, StringBuilder stringBuilder) {
        this.eventSerializer.toSerializable(event, stringBuilder);
    }

    public void encode(LogEvent event, ByteBufferDestination destination) {
        if (this.eventSerializer == null) {
            super.encode(event, destination);
        } else {
            StringBuilder text = ExtendedPatternLayout.toText((AbstractStringLayout.Serializer2)this.eventSerializer, event, ExtendedPatternLayout.getStringBuilder());
            Encoder encoder = this.getStringBuilderEncoder();
            encoder.encode((Object)text, destination);
            ExtendedPatternLayout.trimToMaxSize((StringBuilder)text);
        }
    }

    private static StringBuilder toText(AbstractStringLayout.Serializer2 serializer, LogEvent event, StringBuilder destination) {
        return serializer.toSerializable(event, destination);
    }

    public static PatternParser createPatternParser(Configuration config) {
        if (config == null) {
            return new PatternParser(null, KEY, LogEventPatternConverter.class);
        }
        PatternParser parser = (PatternParser)config.getComponent(KEY);
        if (parser == null) {
            parser = new PatternParser(config, KEY, LogEventPatternConverter.class);
            config.addComponent(KEY, (Object)parser);
            parser = (PatternParser)config.getComponent(KEY);
        }
        return parser;
    }

    public String toString() {
        return this.patternSelector == null ? this.conversionPattern : this.patternSelector.toString();
    }

    @PluginFactory
    @Deprecated
    public static ExtendedPatternLayout createLayout(@PluginAttribute(value="pattern", defaultString="%m%n") String pattern, @PluginElement(value="PatternSelector") PatternSelector patternSelector, @PluginConfiguration Configuration config, @PluginElement(value="Replace") RegexReplacement replace, @PluginAttribute(value="charset") Charset charset, @PluginAttribute(value="alwaysWriteExceptions", defaultBoolean=true) boolean alwaysWriteExceptions, @PluginAttribute(value="noConsoleNoAnsi") boolean noConsoleNoAnsi, @PluginAttribute(value="header") String headerPattern, @PluginAttribute(value="footer") String footerPattern) {
        return ExtendedPatternLayout.newBuilder().withPattern(pattern).withPatternSelector(patternSelector).withConfiguration(config).withRegexReplacement(replace).withCharset(charset).withAlwaysWriteExceptions(alwaysWriteExceptions).withNoConsoleNoAnsi(noConsoleNoAnsi).withHeader(headerPattern).withFooter(footerPattern).withInitNewLine(false).withPrettyPrinting(false).build();
    }

    public static ExtendedPatternLayout createDefaultLayout() {
        return ExtendedPatternLayout.newBuilder().build();
    }

    public static ExtendedPatternLayout createDefaultLayout(Configuration configuration) {
        return ExtendedPatternLayout.newBuilder().withConfiguration(configuration).build();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public AbstractStringLayout.Serializer getEventSerializer() {
        return this.eventSerializer;
    }

    public static class SerializerBuilder
    implements org.apache.logging.log4j.core.util.Builder<AbstractStringLayout.Serializer> {
        private Configuration configuration;
        private RegexReplacement replace;
        private String pattern;
        private String defaultPattern;
        private PatternSelector patternSelector;
        private boolean alwaysWriteExceptions;
        private boolean disableAnsi;
        private boolean noConsoleNoAnsi;
        private boolean initNewLine;
        private boolean prettyPrinting;

        public AbstractStringLayout.Serializer build() {
            if (Strings.isEmpty((CharSequence)this.pattern) && Strings.isEmpty((CharSequence)this.defaultPattern)) {
                return null;
            }
            if (this.patternSelector == null) {
                try {
                    PatternParser parser = ExtendedPatternLayout.createPatternParser(this.configuration);
                    List list = parser.parse(this.pattern == null ? this.defaultPattern : this.pattern, this.alwaysWriteExceptions, this.disableAnsi, this.noConsoleNoAnsi);
                    PatternFormatter[] formatters = list.toArray(new PatternFormatter[0]);
                    return new ExtendedPatternLayoutSerializer(formatters, this.replace, this.initNewLine, this.prettyPrinting);
                }
                catch (RuntimeException var4) {
                    throw new IllegalArgumentException("Cannot parse pattern '" + this.pattern + "'", var4);
                }
            }
            return new PatternSelectorSerializer(this.patternSelector, this.replace);
        }

        public SerializerBuilder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public SerializerBuilder setReplace(RegexReplacement replace) {
            this.replace = replace;
            return this;
        }

        public SerializerBuilder setPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public SerializerBuilder setDefaultPattern(String defaultPattern) {
            this.defaultPattern = defaultPattern;
            return this;
        }

        public SerializerBuilder setPatternSelector(PatternSelector patternSelector) {
            this.patternSelector = patternSelector;
            return this;
        }

        public SerializerBuilder setAlwaysWriteExceptions(boolean alwaysWriteExceptions) {
            this.alwaysWriteExceptions = alwaysWriteExceptions;
            return this;
        }

        public SerializerBuilder setDisableAnsi(boolean disableAnsi) {
            this.disableAnsi = disableAnsi;
            return this;
        }

        public SerializerBuilder setNoConsoleNoAnsi(boolean noConsoleNoAnsi) {
            this.noConsoleNoAnsi = noConsoleNoAnsi;
            return this;
        }

        public SerializerBuilder setInitNewLine(boolean initNewLine) {
            this.initNewLine = initNewLine;
            return this;
        }

        public SerializerBuilder setPrettyPrinting(boolean prettyPrinting) {
            this.prettyPrinting = prettyPrinting;
            return this;
        }
    }

    public static final class Builder
    implements org.apache.logging.log4j.core.util.Builder<ExtendedPatternLayout> {
        @PluginBuilderAttribute
        private String pattern = "%m%n";
        @PluginElement(value="PatternSelector")
        private PatternSelector patternSelector;
        @PluginConfiguration
        private Configuration configuration;
        @PluginElement(value="Replace")
        private RegexReplacement regexReplacement;
        @PluginBuilderAttribute
        private Charset charset = Charset.defaultCharset();
        @PluginBuilderAttribute
        private boolean alwaysWriteExceptions = true;
        @PluginBuilderAttribute
        private boolean disableAnsi = !Builder.useAnsiEscapeCodes();
        @PluginBuilderAttribute
        private boolean noConsoleNoAnsi;
        @PluginBuilderAttribute
        private String header;
        @PluginBuilderAttribute
        private String footer;
        @PluginBuilderAttribute
        private boolean initNewLine;
        @PluginBuilderAttribute
        private boolean prettyPrinting;

        private Builder() {
        }

        private static boolean useAnsiEscapeCodes() {
            PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
            boolean isPlatformSupportsAnsi = !propertiesUtil.isOsWindows();
            boolean isJansiRequested = !propertiesUtil.getBooleanProperty("log4j.skipJansi", true);
            return isPlatformSupportsAnsi || isJansiRequested;
        }

        public Builder withPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder withPatternSelector(PatternSelector patternSelector) {
            this.patternSelector = patternSelector;
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder withRegexReplacement(RegexReplacement regexReplacement) {
            this.regexReplacement = regexReplacement;
            return this;
        }

        public Builder withCharset(Charset charset) {
            if (charset != null) {
                this.charset = charset;
            }
            return this;
        }

        public Builder withAlwaysWriteExceptions(boolean alwaysWriteExceptions) {
            this.alwaysWriteExceptions = alwaysWriteExceptions;
            return this;
        }

        public Builder withDisableAnsi(boolean disableAnsi) {
            this.disableAnsi = disableAnsi;
            return this;
        }

        public Builder withNoConsoleNoAnsi(boolean noConsoleNoAnsi) {
            this.noConsoleNoAnsi = noConsoleNoAnsi;
            return this;
        }

        public Builder withHeader(String header) {
            this.header = header;
            return this;
        }

        public Builder withFooter(String footer) {
            this.footer = footer;
            return this;
        }

        public Builder withInitNewLine(boolean initNewLine) {
            this.initNewLine = initNewLine;
            return this;
        }

        public Builder withPrettyPrinting(boolean prettyPrinting) {
            this.prettyPrinting = prettyPrinting;
            return this;
        }

        public ExtendedPatternLayout build() {
            if (this.configuration == null) {
                this.configuration = new DefaultConfiguration();
            }
            return new ExtendedPatternLayout(this.configuration, this.regexReplacement, this.pattern, this.patternSelector, this.charset, this.alwaysWriteExceptions, this.disableAnsi, this.noConsoleNoAnsi, this.header, this.footer, this.initNewLine, this.prettyPrinting);
        }
    }

    private static final class ExtendedPatternLayoutSerializer
    implements AbstractStringLayout.Serializer,
    LocationAware {
        private final PatternFormatter[] formatters;
        private final RegexReplacement replace;
        private final boolean initNewLine;
        private final boolean prettyPrinting;

        private ExtendedPatternLayoutSerializer(PatternFormatter[] formatters, RegexReplacement replace, boolean initNewLine, boolean prettyPrinting) {
            this.formatters = formatters;
            this.replace = replace;
            this.initNewLine = initNewLine;
            this.prettyPrinting = prettyPrinting;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toSerializable(LogEvent event) {
            String var3;
            StringBuilder sb = ExtendedPatternLayout.getStringBuilder();
            try {
                var3 = this.toSerializable(event, sb).toString();
            }
            finally {
                ExtendedPatternLayout.trimToMaxSize((StringBuilder)sb);
            }
            return var3;
        }

        public StringBuilder toSerializable(LogEvent event, StringBuilder builder) {
            Arrays.stream(this.formatters).forEachOrdered(formatter -> formatter.format(event, builder));
            if (this.replace != null) {
                String str = builder.toString();
                str = this.replace.format(str);
                builder.setLength(0);
                builder.append(str);
            }
            Class<byte[]> bArrayClass = byte[].class;
            if (event != null && event.getMessage() != null && event.getMessage().getParameters() != null) {
                for (Object param : event.getMessage().getParameters()) {
                    if (param == null || !bArrayClass.equals(param.getClass())) continue;
                    builder.replace(builder.indexOf(Arrays.toString((byte[])param)), builder.indexOf(Arrays.toString((byte[])param)) + Arrays.toString((byte[])param).length(), DataConverter.bytesToHexString((byte[])param, this.prettyPrinting, this.initNewLine));
                }
            }
            return builder;
        }

        public boolean requiresLocation() {
            return Arrays.stream(this.formatters).anyMatch(PatternFormatter::requiresLocation);
        }

        public String toString() {
            return super.toString() + "[formatters=" + Arrays.toString(this.formatters) + ", replace=" + this.replace.toString() + "]";
        }
    }

    private static final class PatternSelectorSerializer
    implements AbstractStringLayout.Serializer,
    LocationAware {
        private final PatternSelector patternSelector;
        private final RegexReplacement replace;

        private PatternSelectorSerializer(PatternSelector patternSelector, RegexReplacement replace) {
            this.patternSelector = patternSelector;
            this.replace = replace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toSerializable(LogEvent event) {
            String var3;
            StringBuilder sb = ExtendedPatternLayout.getStringBuilder();
            try {
                var3 = this.toSerializable(event, sb).toString();
            }
            finally {
                ExtendedPatternLayout.trimToMaxSize((StringBuilder)sb);
            }
            return var3;
        }

        public StringBuilder toSerializable(LogEvent event, StringBuilder builder) {
            PatternFormatter[] formatters = this.patternSelector.getFormatters(event);
            Arrays.stream(formatters).forEachOrdered(formatter -> formatter.format(event, builder));
            if (this.replace != null) {
                String str = builder.toString();
                str = this.replace.format(str);
                builder.setLength(0);
                builder.append(str);
            }
            return builder;
        }

        public boolean requiresLocation() {
            return this.patternSelector instanceof LocationAware && ((LocationAware)this.patternSelector).requiresLocation();
        }

        public String toString() {
            return super.toString() + "[patternSelector=" + this.patternSelector.toString() + ", replace=" + this.replace.toString() + "]";
        }
    }
}

