/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.integer;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.util.DataConverter;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ModifiableInteger
extends ModifiableVariable<Integer> {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer originalValue;

    public ModifiableInteger() {
    }

    public ModifiableInteger(Integer originalValue) {
        this.originalValue = originalValue;
    }

    public ModifiableInteger(ModifiableInteger other) {
        super(other);
        this.originalValue = other.originalValue;
    }

    public ModifiableInteger createCopy() {
        return new ModifiableInteger(this);
    }

    public Integer getAssertEquals() {
        return (Integer)this.assertEquals;
    }

    public void setAssertEquals(Integer assertEquals) {
        this.assertEquals = assertEquals;
    }

    @Override
    public boolean isOriginalValueModified() {
        if (this.getOriginalValue() == null) {
            throw new IllegalStateException("Original value must not be null");
        }
        return this.getOriginalValue().compareTo((Integer)this.getValue()) != 0;
    }

    public byte[] getByteArray(int size) {
        return DataConverter.intToBytes((Integer)this.getValue(), size);
    }

    @Override
    public boolean validateAssertions() {
        boolean valid = true;
        if (this.assertEquals != null && ((Integer)this.assertEquals).compareTo((Integer)this.getValue()) != 0) {
            valid = false;
        }
        return valid;
    }

    @Override
    public Integer getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(Integer originalValue) {
        this.originalValue = originalValue;
    }

    public String toString() {
        return "ModifiableInteger{originalValue=" + this.originalValue + this.innerToString() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModifiableInteger)) {
            return false;
        }
        ModifiableInteger that = (ModifiableInteger)obj;
        return this.getValue() == null ? that.getValue() == null : ((Integer)this.getValue()).equals(that.getValue());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.getValue() != null ? ((Integer)this.getValue()).hashCode() : 0);
        return result;
    }
}

