/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.integer;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;

@XmlRootElement
public class IntegerSubtractModification
extends VariableModification<Integer> {
    @JsonProperty(required=true)
    private int subtrahend;

    private IntegerSubtractModification() {
    }

    public IntegerSubtractModification(Integer subtrahend) {
        this.subtrahend = Objects.requireNonNull(subtrahend, "Subtrahend must not be null");
    }

    public IntegerSubtractModification(IntegerSubtractModification other) {
        this.subtrahend = other.subtrahend;
    }

    public IntegerSubtractModification createCopy() {
        return new IntegerSubtractModification(this);
    }

    @Override
    protected Integer modifyImplementationHook(Integer input) {
        if (input == null) {
            return null;
        }
        return input - this.subtrahend;
    }

    public int getSubtrahend() {
        return this.subtrahend;
    }

    public void setSubtrahend(int subtrahend) {
        this.subtrahend = subtrahend;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.subtrahend);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerSubtractModification other = (IntegerSubtractModification)obj;
        return Objects.equals(this.subtrahend, other.subtrahend);
    }

    public String toString() {
        return "IntegerSubtractModification{subtrahend=" + this.subtrahend + "}";
    }
}

