/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;

@XmlRootElement
public class BigIntegerShiftLeftModification
extends VariableModification<BigInteger> {
    @JsonProperty(required=true)
    private int shift;

    private BigIntegerShiftLeftModification() {
    }

    public BigIntegerShiftLeftModification(int shift) {
        this.shift = shift;
    }

    public BigIntegerShiftLeftModification(BigIntegerShiftLeftModification other) {
        this.shift = other.shift;
    }

    public BigIntegerShiftLeftModification createCopy() {
        return new BigIntegerShiftLeftModification(this);
    }

    @Override
    protected BigInteger modifyImplementationHook(BigInteger input) {
        if (input == null) {
            return null;
        }
        return input.shiftLeft(this.shift);
    }

    public int getShift() {
        return this.shift;
    }

    public void setShift(int shift) {
        this.shift = shift;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.shift;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerShiftLeftModification other = (BigIntegerShiftLeftModification)obj;
        return this.shift == other.shift;
    }

    public String toString() {
        return "BigIntegerShiftLeftModification{shift=" + this.shift + "}";
    }
}

